#!/usr/bin/env bash

set -e

strict=true
prod=false
mavenSettings=

while [[ $# -gt 0 ]]
do
case $1 in
    --non-strict)
    echo "strict checking disabled"
    strict=false
    ;;
    --maven-settings)
    mavenSettings="$2"
    echo "maven settings from $mavenSettings will be used"
    shift
    ;;
    --prod)
    prod=true
    ;;
esac
shift # past argument or value
done

cd full-project

if [[ -z ${mavenSettings} ]]
then
    mvn clean install -Dmaven.repo.local=repository -Dswarm.download.poms -Dswarm.download.sources
else
    mvn clean install -Dmaven.repo.local=repository -s ${mavenSettings} -Dswarm.download.poms -Dswarm.download.sources
fi
