/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.lang.ObjectUtils;

public final class DelayedLogItem {
    private Level level;
    private String text;
    private Throwable exception;

    public Level getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public Throwable getException() {
        return this.exception;
    }

    public DelayedLogItem(Level level, String text, Throwable exception) {
        this.level = level;
        this.text = text;
        this.exception = exception;
    }

    public DelayedLogItem(Level level, String text) {
        this(level, text, null);
    }

    public boolean equals(Object o) {
        if (o instanceof DelayedLogItem) {
            DelayedLogItem other = (DelayedLogItem)o;
            return this.level.equals((Object)other.level) && this.text.equals(other.text) && ObjectUtils.eqOrBothNull(this.exception, other.exception);
        }
        return false;
    }

    public int hashCode() {
        return this.level.hashCode() ^ this.text.hashCode() ^ ObjectUtils.hashOrZero(this.exception);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(String.format(" [ level -> %s, text -> \"%s\", exception -> %s]", new Object[]{this.level, this.text, this.exception}));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ALL,
        CONFIG,
        FINE,
        FINER,
        FINEST,
        INFO,
        OFF,
        SEVERE,
        WARNING;

    }
}

