Summary: The compression and decompression library
Name: zlib
Version: 1.2.7
%define base_release .5
Release: 10%{?dist}%{?base_release}
# /contrib/dotzlib/ have Boost license
License: zlib and Boost
Group: System Environment/Libraries
URL: http://www.zlib.net/
Source: http://www.zlib.net/zlib-%{version}.tar.bz2
Source999: fivextra.tar.bz2

Patch0: zlib-1.2.5-minizip-fixuncrypt.patch
# resolves: #805113
Patch1: zlib-1.2.7-optimized-s390.patch
# resolves: #844791
Patch2: zlib-1.2.7-z-block-flush.patch

BuildRequires: automake, autoconf, libtool

%description
Zlib is a general-purpose, patent-free, lossless data compression
library which is used by many different programs.

%package devel
Summary: Header files and libraries for Zlib development
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
The zlib-devel package contains the header files and libraries needed
to develop programs that use the zlib compression and decompression
library.

%package static
Summary: Static libraries for Zlib development
Group: Development/Libraries
Requires: %{name}-devel = %{version}-%{release}

%description static
The zlib-static package includes static libraries needed
to develop programs that use the zlib compression and
decompression library.

%package -n minizip
Summary: Library for manipulation with .zip archives
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description -n minizip
Minizip is a library for manipulation with files from .zip archives.

%package -n minizip-devel
Summary: Development files for the minizip library
Group: Development/Libraries
Requires: minizip = %{version}-%{release}
Requires: %{name}-devel = %{version}-%{release}
Requires: pkgconfig

%description -n minizip-devel
This package contains the libraries and header files needed for
developing applications which use minizip.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
%patch0 -p1 -b .fixuncrypt
%ifarch s390 s390x
%patch1 -p1 -b .optimized-deflate
%else
# base source mismatch hack
touch deflate.c.optimized-deflate
%endif
%patch2 -p1 -b .z-flush
iconv -f iso-8859-2 -t utf-8 < ChangeLog > ChangeLog.tmp
mv ChangeLog.tmp ChangeLog

%build
export CFLAGS="$RPM_OPT_FLAGS"
export LDFLAGS="$LDFLAGS -Wl,-z,relro"
%{?cross_build:CHOST=%{_tool_triplet}} ./configure --libdir=%{_libdir} --includedir=%{_includedir} --prefix=%{_prefix}
make %{?_smp_mflags}

cd contrib/minizip
autoreconf --install
%configure --enable-static=no
make %{?_smp_mflags}

%check
make test

%install
make install DESTDIR=$RPM_BUILD_ROOT

# Steps to package the zlib tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done 

install -d -m 755 $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install -m 755 `find example* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install -m 755 `find minigzip* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -name '*.o' -o -name '*.c' | xargs rm -rf

cd contrib/minizip
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post -n minizip -p /sbin/ldconfig

%postun -n minizip -p /sbin/ldconfig

%files
%doc README ChangeLog FAQ
%{_libdir}/libz.so.*

%files devel
%doc README doc/algorithm.txt test/example.c
%{_libdir}/libz.so
%{_libdir}/pkgconfig/zlib.pc
%{_includedir}/zlib.h
%{_includedir}/zconf.h
%{_mandir}/man3/zlib.3*

%files static
%doc README
%{_libdir}/libz.a

%files -n minizip
%doc contrib/minizip/MiniZip64_info.txt contrib/minizip/MiniZip64_Changes.txt
%{_libdir}/libminizip.so.*

%files -n minizip-devel
%dir %{_includedir}/minizip
%{_includedir}/minizip/*.h
%{_libdir}/libminizip.so
%{_libdir}/pkgconfig/minizip.pc

%files fivextra
%{prefix}

%changelog
* Thu May 09 2013 baseuser@ibm.com
- Base-8.x spec file
