Name:           perl-Encode
Version:        2.51
%define base_release .3
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch:    %{?cross_arches}
Summary:        Character encodings in Perl
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/Encode/
Source0:        http://www.cpan.org/authors/id/D/DA/DANKOGAI/Encode-%{version}.tar.gz

# upstream 8005a82d8aa83024d72b14e66d9eb97d82029eeb . 
# Remove this if we upgrade to later version.
Patch1046301:   bug-104630-1-Do-not-short-circuit-decode_utf8-with-utf8-flags.patch
#Stringify all decode_utf8() arguments..Bug id : 104630
Patch1046302:   bug-104630-2-Encode-2.54-Stringify-all-decode_utf8-arguments.patch

BuildRequires:  perl
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(File::Spec)
BuildRequires:  perl(File::Spec::Functions)
# Run-time:
BuildRequires:  perl(base)
BuildRequires:  perl(Carp)
BuildRequires:  perl(constant)
BuildRequires:  perl(Exporter)
# Filter::Util::Call is optional
BuildRequires:  perl(Getopt::Long)
# I18N::Langinfo is optional
BuildRequires:  perl(MIME::Base64)
# PerlIO::encoding is optional
BuildRequires:  perl(re)
# Storable is optional
BuildRequires:  perl(XSLoader)
# Tests:
BuildRequires:  perl(IO::Select)
BuildRequires:  perl(IPC::Open3)
BuildRequires:  perl(lib)
%{!?cross_build:BuildRequires:  perl(Test::More)}
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))

%{?perl_default_filter}
%global __provides_exclude %{?__provides_exclude:%__provides_exclude|}^perl\\(Encode::ConfigLocal|MY\\)

%description
The Encode module provides the interface between Perl strings and the rest
of the system. Perl strings are sequences of characters.

# To mirror files from perl-devel (bug #456534)
# Keep architecture specific because files go into vendorarch
%package devel
Summary:        Perl Encode Module Generator
Group:          Development/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl-devel
Requires:       perl(Encode)

%description devel
enc2xs builds a Perl extension for use by Encode from either Unicode Character
Mapping files (.ucm) or Tcl Encoding Files (.enc). You can use enc2xs to add
your own encoding to perl. No knowledge of XS is necessary.


%prep
%setup -q -n Encode-%{version}
%patch1046301 -p1
%patch1046302 -p1 

%build
# Additional scripts can be installed by appending MORE_SCRIPTS, UCM files by
# INSTALL_UCM.
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
make %{?_smp_mflags}

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -exec rm -f {} \;
%{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc AUTHORS Changes README
%{_bindir}/piconv
%{perl_vendorarch}/auto/*
%{perl_vendorarch}/Encode*
%exclude %{perl_vendorarch}/Encode/*.e2x
%exclude %{perl_vendorarch}/Encode/encode.h
%{perl_vendorarch}/encoding.pm
%{_mandir}/man1/piconv.*
%{_mandir}/man3/*

%files devel
%{_bindir}/enc2xs
%{_mandir}/man1/enc2xs.*
%{perl_vendorarch}/Encode/*.e2x
%{perl_vendorarch}/Encode/encode.h

%changelog
* Tue Apr 01 2014 baseuser@ibm.com
- Base-8.x spec file
