Summary: Utility for secure communication and data storage
Name:    gnupg2
Version: 2.0.24
%define base_release .1
Release: 1%{?dist}%{?base_release}

License: GPLv3+
Group:   Applications/System
Source0: ftp://ftp.gnupg.org/gcrypt/%{?pre:alpha/}gnupg/gnupg-%{version}%{?pre}.tar.bz2
Source1: ftp://ftp.gnupg.org/gcrypt/%{?pre:alpha/}gnupg/gnupg-%{version}%{?pre}.tar.bz2.sig
# svn export svn://cvs.gnupg.org/gnupg/trunk gnupg2; tar cjf gnupg-<date>svn.tar.bz2 gnupg2
#Source0: gnupg2-20090809svn.tar.bz2
Source999: fivextra.tar.bz2
Patch1:  gnupg-2.0.20-insttools.patch
Patch3:  gnupg-2.0.20-secmem.patch
Patch4:  gnupg-2.0.18-protect-tool-env.patch
Patch5:  gnupg-2.0.20-ocsp-keyusage.patch
Patch6:  gnupg-2.0.19-fips-algo.patch

URL:     http://www.gnupg.org/

#BuildRequires: automake libtool texinfo transfig
BuildRequires: bzip2-devel
BuildRequires: curl-devel
%{?!base:BuildRequires: docbook-utils}
BuildRequires: gettext
BuildRequires: libassuan-devel >= 2.0.0
BuildRequires: libgcrypt-devel >= 1.4
BuildRequires: libgpg-error-devel => 1.4
BuildRequires: libksba-devel >= 1.0.2
BuildRequires: openldap-devel
BuildRequires: libusb-devel
%{!?cross_build:BuildRequires: pcsc-lite-libs}
BuildRequires: pth-devel
BuildRequires: readline-devel ncurses-devel
BuildRequires: zlib-devel

Requires(post): /sbin/install-info
Requires(postun): /sbin/install-info
%{!?cross_build:Requires: pinentry}

%if 0%{?rhel} > 5 || 0%{?base} > 18
# pgp-tools, perl-GnuPG-Interface requires 'gpg' (not sure why) -- Rex
Provides: gpg = %{version}-%{release}
# Obsolete GnuPG-1 package
Provides: gnupg = %{version}-%{release}
Obsoletes: gnupg <= 1.4.10
%endif

%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%package smime
Summary: CMS encryption and signing tool and smart card support for GnuPG
Requires: gnupg2 = %{version}-%{release}
Group: Applications/Internet


%description
GnuPG is GNU's tool for secure communication and data storage.  It can
be used to encrypt data and to create digital signatures.  It includes
an advanced key management facility and is compliant with the proposed
OpenPGP Internet standard as described in RFC2440 and the S/MIME
standard as described by several RFCs.

GnuPG 2.0 is a newer version of GnuPG with additional support for
S/MIME.  It has a different design philosophy that splits
functionality up into several modules. The S/MIME and smartcard functionality
is provided by the gnupg2-smime package.

%description smime
GnuPG is GNU's tool for secure communication and data storage. This
package adds support for smart cards and S/MIME encryption and signing
to the base GnuPG package 

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n gnupg-%{version} -a 999

%if 0%{?rhel} > 5 || 0%{?base} > 18
%patch1 -p1 -b .insttools
%endif
%patch3 -p1 -b .secmem
%patch4 -p1 -b .ptool-env
%patch5 -p1 -b .keyusage
%patch6 -p1 -b .fips

# pcsc-lite library major: 0 in 1.2.0, 1 in 1.2.9+ (dlopen()'d in pcsc-wrapper)
# Note: this is just the name of the default shared lib to load in scdaemon,
# it can use other implementations too (including non-pcsc ones).
%global pcsclib %(basename $(ls -1 %{_libdir}/libpcsclite.so.? 2>/dev/null ) 2>/dev/null )

sed -i -e 's/"libpcsclite\.so"/"%{pcsclib}"/' scd/{scdaemon,pcsc-wrapper}.c

%build

%configure \
  --disable-rpath \
  --enable-standard-socket

# need scratch gpg database for tests
mkdir -p $HOME/.gnupg

make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=%{buildroot} \
  INSTALL="install -p" \
  docdir=%{_pkgdocdir}

%if ! (0%{?rhel} > 5 || 0%{?base} > 18)
# drop file conflicting with gnupg-1.x
rm -f %{buildroot}%{_mandir}/man1/gpg-zip.1*
%endif

%find_lang %{name}

# gpgconf.conf
mkdir -p %{buildroot}%{_sysconfdir}/gnupg
touch %{buildroot}%{_sysconfdir}/gnupg/gpgconf.conf

# more docs
install -m644 -p AUTHORS COPYING ChangeLog NEWS THANKS TODO \
  %{buildroot}%{_pkgdocdir}

%if 0%{?rhel} > 5 || 0%{?base} > 18
# compat symlinks
ln -sf gpg2 %{buildroot}%{_bindir}/gpg
ln -sf gpgv2 %{buildroot}%{_bindir}/gpgv
ln -sf gpg2.1 %{buildroot}%{_mandir}/man1/gpg.1
ln -sf gpgv2.1 %{buildroot}%{_mandir}/man1/gpgv.1
%endif

# info dir
rm -f %{buildroot}%{_infodir}/dir

# Steps to package the gnupg2 tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 1 \
-name '*.c' -o -name '*.h' -o -name '*.o' | xargs rm -rf

%check
# need scratch gpg database for tests
mkdir -p $HOME/.gnupg
# some gpg2 tests (still) FAIL on non i386 platforms
make -k check


%post
/sbin/install-info %{_infodir}/gnupg.info %{_infodir}/dir ||:

%preun
if [ $1 -eq 0 ]; then
  /sbin/install-info --delete %{_infodir}/gnupg.info %{_infodir}/dir ||:
fi


%files -f %{name}.lang
%defattr(-,root,root,-)
#doc AUTHORS COPYING ChangeLog NEWS README THANKS TODO
%{_pkgdocdir}
%dir %{_sysconfdir}/gnupg
%ghost %config(noreplace) %{_sysconfdir}/gnupg/gpgconf.conf
## docs say to install suid root, but fedora/rh security folk say not to
#attr(4755,root,root) %{_bindir}/gpg2
%{_bindir}/gpg2
%{_bindir}/gpgv2
%{_bindir}/gpg-connect-agent
%{_bindir}/gpg-agent
%{_bindir}/gpgconf
%{_bindir}/gpgparsemail
%if 0%{?rhel} > 5 || 0%{?base} > 18
%{_bindir}/gpg
%{_bindir}/gpgv
%{_bindir}/gpgsplit
%{_bindir}/gpg-zip
%else
%{_bindir}/gpgkey2ssh
%endif
%{_bindir}/watchgnupg
%{_sbindir}/*
%{_datadir}/gnupg/
%{_libexecdir}/*
%{_infodir}/*.info*
%{_mandir}/man?/*
%exclude %{_datadir}/gnupg/com-certs.pem
%exclude %{_mandir}/man?/gpgsm*
%exclude %{_mandir}/man?/scdaemon*
%exclude %{_libexecdir}/scdaemon

%files smime
%defattr(-,root,root,-)
%{_bindir}/gpgsm*
%{_bindir}/kbxutil
%{_libexecdir}/scdaemon
%{_mandir}/man?/gpgsm*
%{_mandir}/man?/scdaemon*
%{_datadir}/gnupg/com-certs.pem

%files fivextra
%{prefix}

%changelog
* Wed Jul 30 2014 baseuser@ibm.com
- Base-f19.x spec file
