Name:             libcroco
Summary:          A CSS2 parsing library
Version:          0.6.8
%define base_release .2
Release:          2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:          LGPLv2
Group:            System Environment/Libraries
Source:           http://download.gnome.org/sources/libcroco/0.6/%{name}-%{version}.tar.xz
Source999:       fivextra.tar.bz2 
#Fedora specific patch
Patch0:    libcroco-0.6.1-multilib.patch

BuildRequires:    pkgconfig
BuildRequires:    glib2-devel
BuildRequires:    libxml2-devel

%description
CSS2 parsing and manipulation library for GNOME

%package devel
Summary:          Libraries and include files for developing with libcroco
Group:            Development/Libraries
Requires:         %{name} = %{version}-%{release}
Requires:         glib2-devel
Requires:         libxml2-devel

%description devel
This package provides the necessary development libraries and include
files to allow you to develop with libcroco.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the FIV testcases for %{name} 

%prep
%setup -q -n libcroco-%{version} -a 999
%patch0 -p1 -b .multilib

%build
%configure --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

%check
make check

#Steps to package the libcroco tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
 install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

tdir=$RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
[ ! -d $tdir ] && install -d -m 755 $tdir
install -m 755 tests/.libs/test* $tdir
# The test-inputs dir contains the css files used for the tests
install -m 755 tests/test-inputs/test* $tdir
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%doc AUTHORS COPYING COPYING.LIB NEWS README 
%{_bindir}/csslint-0.6
%{_libdir}/*.so.*

%files devel
%{_libdir}/*.so
%{_includedir}/libcroco-0.6
%{_bindir}/croco-0.6-config
%{_libdir}/pkgconfig/libcroco-0.6.pc
%{_datadir}/gtk-doc/html/libcroco

%files fivextra
%{prefix}

%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
