%define soversion 0
%define soname libdwarf.so.%{soversion}
%define sofullname libdwarf.so.%{soversion}.%{version}.0

Name:          libdwarf
Version:       20130207
%define base_release .2
Release:       1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch:   mips64 ppca2 ppc476 ppcnf
Summary:       Library to access the DWARF Debugging file format 
Group:         Development/Libraries

License:       LGPLv2
URL:           http://reality.sgiweb.org/davea/dwarf.html
Source0:       http://reality.sgiweb.org/davea/%{name}-%{version}.tar.gz
Patch0:        libdwarf-soname.patch

BuildRequires: binutils-devel elfutils-libelf-devel

%package devel
Summary:       Library and header files of libdwarf
Group:         Development/Libraries
License:       LGPLv2
Requires:      %{name} = %{version}-%{release}

%package static
Summary:       Static libdwarf library
Group:         Development/Libraries
License:       LGPLv2
Requires:      %{name}-devel = %{version}-%{release}

%package tools
Summary:       Tools for accessing DWARF debugging information
Group:         Development/Tools
License:       GPLv2
Requires:      %{name} = %{version}-%{release}

%description
Library to access the DWARF debugging file format which supports
source level debugging of a number of procedural languages, such as C, C++,
and Fortran.  Please see http://www.dwarfstd.org for DWARF specification.

%description static
Static libdwarf library.

%description devel
Development package containing library and header files of libdwarf.

%description tools
C++ version of dwarfdump (dwarfdump2) command-line utilities 
to access DWARF debug information.

%prep
%setup -q -n dwarf-%{version}
%patch0 -p1 -b .soname

%build
CFLAGS="$RPM_OPT_FLAGS" %configure --enable-shared
LD_LIBRARY_PATH="../libdwarf" make %{?_smp_mflags} SONAME="%{soname}"

%install
install -pDm 0644 libdwarf/dwarf.h         %{buildroot}%{_includedir}/libdwarf/dwarf.h
install -pDm 0644 libdwarf/libdwarf.a      %{buildroot}%{_libdir}/libdwarf.a

install -pDm 0644 libdwarf/libdwarf.h      %{buildroot}%{_includedir}/libdwarf/libdwarf.h
install -pDm 0755 libdwarf/libdwarf.so     %{buildroot}%{_libdir}/%{sofullname}
ln      -s        %{sofullname}            %{buildroot}%{_libdir}/%{soname}
ln      -s        %{sofullname}            %{buildroot}%{_libdir}/libdwarf.so
install -pDm 0755 dwarfdump2/dwarfdump     %{buildroot}%{_bindir}/dwarfdump

%post -n libdwarf -p /sbin/ldconfig

%postun -n libdwarf -p /sbin/ldconfig

%files
%doc libdwarf/ChangeLog libdwarf/README libdwarf/COPYING libdwarf/LIBDWARFCOPYRIGHT libdwarf/LGPL.txt
%{_libdir}/libdwarf.so.*

%files static
%{_libdir}/libdwarf.a

%files devel
%doc libdwarf/*.pdf
%{_includedir}/libdwarf
%{_libdir}/libdwarf.so

%files tools
%doc dwarfdump2/README dwarfdump2/ChangeLog dwarfdump2/COPYING dwarfdump2/DWARFDUMPCOPYRIGHT dwarfdump2/GPL.txt
%{_bindir}/dwarfdump

%changelog
* Tue Jun 18 2013 baseuser@ibm.com
- Base-8.x spec file
