Summary:    A Router Advertisement daemon
Name:       radvd
Version:    1.9.2
%define base_release .3
Release:    3%{?base_release}%{?dist}
ExcludeArch: ppc476 ppcnf ppca2 mips64
# The code includes the advertising clause, so it's GPL-incompatible
License:    BSD with advertising
Group:      System Environment/Daemons
URL:        http://www.litech.org/radvd/
Source0:    %{url}dist/%{name}-%{version}.tar.gz
Source1:    radvd-tmpfs.conf
Source2:    radvd.service
Source999:  fivextra.tar.bz2
BuildRequires:      byacc
BuildRequires:      flex
BuildRequires:      flex-static
BuildRequires:      libdaemon-devel
BuildRequires:      pkgconfig
BuildRequires:      systemd-units
Requires(postun):   systemd-units
Requires(preun):    systemd-units
Requires(post):     systemd-units
Requires(pre):      shadow-utils

%description
radvd is the router advertisement daemon for IPv6.  It listens to router
solicitations and sends router advertisements as described in "Neighbor
Discovery for IP Version 6 (IPv6)" (RFC 2461).  With these advertisements
hosts can automatically configure their addresses and some other
parameters.  They also can choose a default router based on these
advertisements.

Install radvd if you are setting up IPv6 network and/or Mobile IPv6
services.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
for F in CHANGES; do
    iconv -f iso-8859-1 -t utf-8 < "$F" > "${F}.new"
    touch -r "$F" "${F}.new"
    mv "${F}.new" "$F"
done

%build
export CFLAGS="$RPM_OPT_FLAGS -fPIE" 
export LDFLAGS='-pie -Wl,-z,relro,-z,now,-z,noexecstack,-z,nodlopen'
%configure --with-pidfile=%{_localstatedir}/run/radvd/radvd.pid
make %{?_smp_mflags} 

%install
make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/radvd
mkdir -p $RPM_BUILD_ROOT%{_unitdir}

install -m 644 redhat/radvd.conf.empty $RPM_BUILD_ROOT%{_sysconfdir}/radvd.conf
install -m 644 redhat/radvd.sysconfig $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/radvd

install -d -m 755 $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d
install -p -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}/tmpfiles.d/radvd.conf
install -m 644 %{SOURCE2} ${RPM_BUILD_ROOT}%{_unitdir}

# Steps to package the radvd tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

%postun
%systemd_postun_with_restart radvd.service

%post
%systemd_post radvd.service

%preun
%systemd_preun radvd.service

# Static UID and GID defined by /usr/share/doc/setup-*/uidgid
%pre
getent group radvd >/dev/null || groupadd -r -g 75 radvd
getent passwd radvd >/dev/null || \
  useradd -r -u 75 -g radvd -d / -s /sbin/nologin -c "radvd user" radvd
exit 0

%files
%doc CHANGES COPYRIGHT INTRO.html README TODO
%{_unitdir}/radvd.service
%config(noreplace) %{_sysconfdir}/radvd.conf
%config(noreplace) %{_sysconfdir}/sysconfig/radvd
%config(noreplace) %{_sysconfdir}/tmpfiles.d/radvd.conf
%dir %attr(-,radvd,radvd) %{_localstatedir}/run/radvd/
%doc radvd.conf.example
%{_mandir}/*/*
%{_sbindir}/radvd
%{_sbindir}/radvdump

%files fivextra
%{prefix}

%changelog
* Tue Jun 11 2013 baseuser@ibm.com
- Base-8.x spec file
