Summary:	The ASN.1 library used in GNUTLS
Name:		libtasn1
Version:	3.6
%define base_release .1
Release:	1%{?dist}%{?base_release}

# The libtasn1 library is LGPLv2+, utilities are GPLv3+
License:	GPLv3+ and LGPLv2+
Group:		System Environment/Libraries
URL:		http://www.gnu.org/software/libtasn1/
Source0:	http://ftp.gnu.org/gnu/libtasn1/%name-%version.tar.gz
Source1:	http://ftp.gnu.org/gnu/libtasn1/%name-%version.tar.gz.sig
Source999:     fivextra.tar.bz2

Patch1:		libtasn1-3.4-rpath.patch
BuildRequires:	bison, pkgconfig
%ifarch %ix86 x86_64 ppc ppc64
BuildRequires:	valgrind
%endif
# Wildcard bundling exception https://fedorahosted.org/fpc/ticket/174
Provides: bundled(gnulib) = 20130324

%package devel
Summary:	Files for development of applications which will use libtasn1
Group:		Development/Libraries
Requires:	%name = %version-%release
Requires:	pkgconfig
Requires(post):		/sbin/install-info
Requires(postun):	/sbin/install-info


%package tools
Summary:	Some ASN.1 tools
Group:		Applications/Text
License:	GPLv3+
Requires:	%name = %version-%release


%description
A library that provides Abstract Syntax Notation One (ASN.1, as specified
by the X.680 ITU-T recommendation) parsing and structures management, and
Distinguished Encoding Rules (DER, as per X.690) encoding and decoding functions.

%description devel
This package contains files for development of applications which will
use libtasn1.


%description tools
This package contains simple tools that can decode and encode ASN.1
data.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}


%prep
%setup -q -a 999

%patch1 -p1 -b .rpath

%build
%configure --disable-static --disable-silent-rules
# libtasn1 likes to regenerate docs
touch doc/stamp_docs

make %{?_smp_mflags}


%install
make DESTDIR="$RPM_BUILD_ROOT" install

rm -f $RPM_BUILD_ROOT{%_libdir/*.la,%_infodir/dir}

# Steps to package the libtasn1 tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/tests
install  $(find tests/ -maxdepth 1 -type f -not -name '*.o' -not -name '*.c' -not -name 'Makefile*') $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/examples
install examples/pkix.asn $RPM_BUILD_ROOT%{fivdir}/%{name}/examples
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/src
install src/.libs/asn1Decoding $RPM_BUILD_ROOT/%{fivdir}/%{name}/src

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd


%check
make check


%post   -p /sbin/ldconfig
%postun -p /sbin/ldconfig


%post devel
test -f %_infodir/%name.info.gz && \
	/sbin/install-info --info-dir=%_infodir %_infodir/%name.info || :

%preun devel
test "$1" = 0 -a -f %_infodir/%name.info.gz && \
	/sbin/install-info --info-dir=%_infodir --delete %_infodir/%name.info || :

%files
%defattr(-,root,root,-)
%doc doc/TODO doc/*.pdf
%doc AUTHORS COPYING* NEWS README THANKS
%_libdir/*.so.6*

%files tools
%defattr(-,root,root,-)
%_bindir/asn1*
%_mandir/man1/asn1*

%files devel
%defattr(-,root,root,-)
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_includedir/*
%_infodir/*.info.*
%_mandir/man3/*asn1*

%files fivextra
%{prefix}


%changelog
* Thu Jul 31 2014 baseuser@ibm.com
- Base-8.x spec file
