%global fontname sil-padauk
%global fontconf 65-%{fontname}
%global archivename padauk-2.8

%global common_desc \
Padauk is a Myanmar font covering all currently used characters \
in the Myanmar block. The font aims to cover all minority language needs. \
At the moment, these do not extend to stylistic variation needs. \
The font is a smart font using a Graphite description.

Name:    %{fontname}-fonts
Version: 2.8
%define base_release .1
Release: 4%{?dist}%{?base_release}
Summary: A font for Burmese and the Myanmar script

Group:   User Interface/X
License: OFL
URL:     http://scripts.sil.org/Padauk
# The source link is a redirect and is not directly accessible
Source0: %{archivename}.zip
Source1: %{name}-fontconfig.conf
Source2: %{name}-book-fontconfig.conf

BuildArch: noarch
BuildRequires: fontpackages-devel
BuildRequires: fonttools
Requires:      fontpackages-filesystem

%description
%common_desc

%_font_pkg -f %{fontconf}.conf Padauk.ttf Padauk-bold.ttf
%doc *.txt

%package -n %{fontname}-book-fonts
Summary:  A font for Burmese and the Myanmar script

%description -n %{fontname}-book-fonts
Padauk Book family font.

%common_desc

%_font_pkg -n book -f %{fontconf}-book.conf Padauk-book*.ttf
%doc *.txt

%prep
%setup -q -n padauk-2.80
sed -i 's/\r//' OFL.txt

%build
# Following is needed to fix the postscript font name
ttx *.ttf
sed -i 's|&#225;&#128;&#149;&#225;&#128;&#173;&#225;&#128;&#144;&#225;&#128;&#177;&#225;&#128;&#172;&#225;&#128;&#128;&#225;&#128;&#186;|Padauk|g' Padauk*.ttx

sed -i 's|&#225;&#128;&#133;&#225;&#128;&#172;&#225;&#128;&#156;&#225;&#128;&#175;&#225;&#128;&#182;&#225;&#128;&#184;&#225;&#128;&#153;&#225;&#128;&#178;|Bold|g' Padauk*.ttx

sed -i 's|&#225;&#128;&#133;&#225;&#128;&#172;&#225;&#128;&#161;&#225;&#128;&#175;&#225;&#128;&#149;&#225;&#128;&#186;|Book|g' Padauk-book*.ttx
rm *.ttf
ttx Padauk*.ttx

rm *.ttx


%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.ttf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE1} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}.conf
install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-book.conf

ln -s %{_fontconfig_templatedir}/%{fontconf}.conf \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}.conf

ln -s %{_fontconfig_templatedir}/%{fontconf}-book.conf \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}-book.conf


%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
