
Name:    gpgme
Summary: GnuPG Made Easy - high level crypto API
Version: 1.3.2
%define base_release .3
Release: 3%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: LGPLv2+
Group:   Applications/System
URL:     http://www.gnupg.org/related_software/gpgme/
Source0: ftp://ftp.gnupg.org/gcrypt/gpgme/gpgme-%{version}.tar.bz2
Source1: ftp://ftp.gnupg.org/gcrypt/gpgme/gpgme-%{version}.tar.bz2.sig
Source2: gpgme-multilib.h
Source999: fivextra.tar.bz2 
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Patch1: gpgme-1.3.2-config_extras.patch

# fix ImplicitDSOLinking in tests/, upstreamable
Patch2:  gpgme-1.3.2-ImplicitDSOLinking.patch

# add -D_FILE_OFFSET_BITS... to gpgme-config, upstreamable
Patch3:  gpgme-1.3.2-largefile.patch

BuildRequires: gawk
BuildRequires: gnupg2
BuildRequires: gnupg2-smime
BuildRequires: libgpg-error-devel
BuildRequires: pth-devel
BuildRequires: libassuan2-devel

%define _with_gpg --with-gpg=%{_bindir}/gpg2
Requires: gnupg2

# On the following architectures workaround multiarch conflict of -devel packages:
%define multilib_arches %{ix86} x86_64 ia64 ppc ppc64 s390 s390x %{sparc}

%description
GnuPG Made Easy (GPGME) is a library designed to make access to GnuPG
easier for applications.  It provides a high-level crypto API for
encryption, decryption, signing, signature verification and key
management.

%package devel
Summary:  Development headers and libraries for %{name}
Group:    Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: libgpg-error-devel%{?_isa}
# http://bugzilla.redhat.com/676954
# TODO: see if -lassuan can be added to config_extras patch too -- Rex
#Requires: libassuan2-devel
# /usr/share/aclocal ownership
#Requires: automake
Requires(post): /sbin/install-info
Requires(postun): /sbin/install-info
%description devel
%{summary}

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: gnupg2-smime

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%patch1 -p1 -b .config_extras
%patch2 -p1 -b .ImplicitDSOLinking
%patch3 -p1 -b .largefile

## HACK ALERT
# The config script already suppresses the -L if it's /usr/lib, so cheat and
# set it to a value which we know will be suppressed.
sed -i -e 's|^libdir=@libdir@$|libdir=@exec_prefix@/lib|g' src/gpgme-config.in

%build
%configure \
  --disable-static \
  --without-g13 \
  %{?_with_gpg}

make %{?_smp_mflags}

pushd tests/gpg
make
popd
pushd tests/gpgsm
make
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT

# unpackaged files
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.la
rm -rf $RPM_BUILD_ROOT%{_datadir}/common-lisp/source/gpgme/

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find tests -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done 

mv $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/gpg/.libs $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/gpg/bin
mv $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/gpgsm/.libs $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/gpgsm/bin

pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}/
  find . -type f -name '*.o' | xargs rm -f
#Removing t-genkey tests as it takes really long time to generate keys
#http://code.metager.de/source/xref/gnupg/gpgme/tests/gpgsm/Makefile.am
  rm -f tests/gpg/bin/t-genkey
popd 

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# Hack to resolve multiarch conflict (#341351)
%ifarch %{multilib_arches}
mv $RPM_BUILD_ROOT%{_bindir}/gpgme-config{,.%{_target_cpu}}
cat > gpgme-config-multilib.sh <<__END__
#!/bin/sh
exec %{_bindir}/gpgme-config.\$(arch) \$@
__END__
install -D -p gpgme-config-multilib.sh $RPM_BUILD_ROOT%{_bindir}/gpgme-config
mv $RPM_BUILD_ROOT%{_includedir}/gpgme.h \
   $RPM_BUILD_ROOT%{_includedir}/gpgme-%{__isa_bits}.h
install -m644 -p -D %{SOURCE2} $RPM_BUILD_ROOT%{_includedir}/gpgme.h
%endif


%check 
make -C tests check 


%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING* ChangeLog NEWS README* THANKS TODO VERSION
%{_libdir}/libgpgme.so.11*
%{_libdir}/libgpgme-pthread.so.11*

%post devel
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir 2>/dev/null || :

%preun devel
if [ $1 -eq 0 ] ; then
  /sbin/install-info --delete %{_infodir}/%{name}.info %{_infodir}/dir 2>/dev/null || :
fi

%files devel
%defattr(-,root,root,-)
%{_bindir}/gpgme-config
%ifarch %{multilib_arches}
%{_bindir}/gpgme-config.%{_target_cpu}
%{_includedir}/gpgme-%{__isa_bits}.h
%endif
%{_includedir}/gpgme.h
%{_libdir}/libgpgme*.so
%{_datadir}/aclocal/gpgme.m4
%{_infodir}/gpgme.info*

%files fivextra
%{prefix}

%changelog
* Fri May 17 2013 baseuser@ibm.com
- Base-8.x spec file
