#allow remote set quota by defined rpcsetquota to 1(set to 0 to disabled it)
%{!?rpcsetquota:%define rpcsetquota 1}

Name: quota
Summary: System administration tools for monitoring users' disk usage
Epoch: 1
Version: 4.01
%define base_release .1
Release: 8%{?dist}%{?base_release}
# quota_nld.c, quotaio_xfs.h:       GPLv2
# bylabel.c copied from util-linux: GPLv2+
# svc_socket.c copied from glibc:   LGPLv2+
# doc/quotas.ms, quotaops.c, quot.c, quotaon.c, edquota.c, quot.h, quota.c,
# quotaio_v1.c:                     BSD
License: BSD and LGPLv2+ and GPLv2 and GPLv2+
URL: http://sourceforge.net/projects/linuxquota/
Group: System Environment/Base
Requires: initscripts >= 6.38 tcp_wrappers
Requires: quota-nls = %{epoch}:%{version}-%{release}
Conflicts: kernel < 2.4
BuildRequires: e2fsprogs-devel gettext tcp_wrappers-devel
BuildRequires: openldap-devel dbus-devel libnl-devel
BuildRequires: systemd-units
Source0: http://downloads.sourceforge.net/linuxquota/%{name}-%{version}.tar.gz
Source1: quota_nld.service
Source2: quota_nld.sysconfig
Source999: fivextra.tar.bz2
# Not accepted changes (378a64006bb1e818e84a1c77808563b802b028fa)
# Some of the lines have been superseded by other commits probably.
Patch0: quota-4.01-warnquota.patch
Patch1: quota-3.06-man-page.patch
Patch2: quota-3.06-pie.patch
Patch3: quota-3.13-wrong-ports.patch
# Submitted to upstream, SF#3571486
Patch4: quota-4.01-Make-group-warning-message-more-official.patch
# In upstream after 4.01, SF#3571589
Patch5: quota-4.01-define_charset_in_mail.patch
# In upstream after 4.01, SF#3602786, bug #846296
Patch6: quota-4.01-Do-not-fiddle-with-quota-files-on-XFS-and-GFS.patch
# In upstream after 4.01, SF#3602777
Patch7: quota-4.01-quotacheck-Make-sure-d-provides-at-least-as-much-inf.patch
# In upstream after 4.01, SF#3607034
Patch8: quota-4.01-Add-quotasync-1-manual-page.patch
# In upstream after 4.01, SF#3607034
Patch9: quota-4.01-Complete-quotasync-usage.patch
# In upstream after 4.01, SF#3607034
Patch10: quota-4.01-Correct-quotasync-exit-code.patch
# In upstream after 4.01, SF#3607038
Patch11: quota-4.01-Fix-various-usage-mistakes.patch
# In upstream after 4.01, SF#3600120
Patch12: quota-4.01-Recognize-units-at-block-limits-by-setquota.patch
# In upstream after 4.01, SF#3600120
Patch13: quota-4.01-Recognize-block-limit-units-on-setquota-standard-inp.patch
# In upstream after 4.01, SF#3600120
Patch14: quota-4.01-Recognize-units-at-block-limits-by-edquota.patch
# In upstream after 4.01, SF#3600120
Patch15: quota-4.01-Recognize-units-at-inode-limits-by-setquota.patch
# In upstream after 4.01, SF#3600120
Patch16: quota-4.01-Recognize-units-at-inode-limits-by-edquota.patch
# Submited to upstream
Patch17: quota-4.01-Close-FILE-handles-on-error.patch


%description
The quota package contains system administration tools for monitoring
and limiting user and or group disk usage per file system.


%package nld
Summary: quota_nld daemon
Group: System Environment/Base
Requires: quota-nls = %{epoch}:%{version}-%{release}
Requires(post): systemd-sysv systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

%description nld
Daemon that listens on netlink socket and processes received quota warnings.
Note, that you have to enable the kernel support for sending quota messages
over netlink (in Filesystems->Quota menu). The daemon supports forwarding
warning messages to the system D-Bus (so that desktop manager can display
a dialog) and writing them to the terminal user has last accessed.


%package warnquota
Summary: Send e-mail to users over quota
Group: System Environment/Base
Requires: quota-nls = %{epoch}:%{version}-%{release}

%description warnquota
Utility that checks disk quota for each local file system and mails a warning
message to those users who have reached their soft limit.  It is typically run
via cron(8).


%package nls
Summary: Gettext catalogs for disk quota tools
Group: System Environment/Base
BuildArch: noarch

%description nls
Disk quota tools messages translated into different natural languages.


%package devel
Summary: Development files for quota
Group: System Environment/Base
Requires: quota =  %{epoch}:%{version}-%{release}

%description devel
The quota package contains system administration tools for monitoring
and limiting user and or group disk usage per file system.

This package contains development header files for implementing quotas
on remote machines.


%package doc
Summary: Additional documentation for disk quotas
Group: Documentation
Requires: quota =  %{epoch}:%{version}-%{release}
BuildArch: noarch
AutoReq: 0

%description doc
This package contains additional documentation for disk quotas concept in
Linux/UNIX environment.

%package fivextra 
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n quota-tools -a 999
%patch0 -p1
%patch1 -p1
%ifnarch ppc ppc64
%patch2 -p1
%endif
%patch3 -p1
%patch4 -p1 -b .group_warning
%patch5 -p1 -b .charset_in_mail
%patch6 -p1 -b .gfs_files
%patch7 -p1 -b .quotackeck_debug
%patch8 -p1 -b .quotasync_manual
%patch9 -p1 -b .quotasync_usage
%patch10 -p1 -b .quotasync_exit
%patch11 -p1 -b .usage
%patch12 -p1 -b .setquota_block_units
%patch13 -p1 -b .setquota_block_units_stdin
%patch14 -p1 -b .edquota_block_units
%patch15 -p1 -b .setquota_inode_units
%patch16 -p1 -b .edquota_inode_units
%patch17 -p1 -b .close_file_handles

#fix typos/mistakes in localized documentation
for pofile in $(find ./po/*.p*)
do
   sed -i 's/editting/editing/' "$pofile"
done

# Fix charset
for F in Changelog; do
    iconv -f latin1 -t utf-8 <"$F" >"${F}.utf8"
    touch -r "$F"{,.utf8}
    mv "$F"{.utf8,}
done


%build
%configure \
    --enable-ext2direct=yes \
    --enable-ldapmail=yes \
    --enable-netlink=yes \
    --enable-rootsbin=yes \
%if %{rpcsetquota}
    --enable-rpcsetquota=yes \
%endif
    --enable-strip-binaries=no
make

pushd fivextra
make all
popd

%install
mkdir -p %{buildroot}/sbin
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_sbindir}
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}/{man1,man3,man8}
make install INSTALL='install -p' ROOTDIR=%{buildroot}
install -m 644 warnquota.conf %{buildroot}%{_sysconfdir}
ln -s  quotaon.8.gz \
  %{buildroot}%{_mandir}/man8/quotaoff.8
ln -s rquotad.8.gz \
   %{buildroot}%{_mandir}/man8/rpc.rquotad.8

install -p -m644 -D %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/quota_nld.service
install -p -m644 -D %{SOURCE2} \
    $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/quota_nld

# Steps to package the quota tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name}


%post nld
%systemd_post quota_nld.service

%preun nld
%systemd_preun quota_nld.service

%postun nld
%systemd_postun_with_restart quota_nld.service

%triggerun -- %{name}-nld < 1:4.00-2
echo 'quota-nld: User must migrate to systemd target manually by runnig:'
echo '  systemd-sysv-convert --apply quota_nld'
# Save the current service runlevel info
/usr/bin/systemd-sysv-convert --save quota_nld >/dev/null 2>&1 || :
# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del quota_nld >/dev/null 2>&1 || :
/bin/systemctl try-restart quota_nld.service >/dev/null 2>&1 || :


%files
%attr(0755,root,root) /sbin/*
%attr(0755,root,root) %{_bindir}/*
%attr(0755,root,root) %{_sbindir}/*
%exclude %{_sbindir}/quota_nld
%exclude %{_sbindir}/warnquota
%attr(0644,root,root) %{_mandir}/man1/*
%attr(0644,root,root) %{_mandir}/man8/*
%exclude %{_mandir}/man8/quota_nld.8*
%exclude %{_mandir}/man8/warnquota.8*
%doc Changelog

%files nld
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/sysconfig/quota_nld
%{_unitdir}/quota_nld.service
%attr(0755,root,root) %{_sbindir}/quota_nld
%attr(0644,root,root) %{_mandir}/man8/quota_nld.8*
%doc Changelog

%files warnquota
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/quotagrpadmins
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/quotatab
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/warnquota.conf
%attr(0755,root,root) %{_sbindir}/warnquota
%attr(0644,root,root) %{_mandir}/man8/warnquota.8*
%doc Changelog README.ldap-support README.mailserver

%files nls -f %{name}.lang
%doc Changelog

%files devel
%dir %{_includedir}/rpcsvc
%{_includedir}/rpcsvc/*
%attr(0644,root,root) %{_mandir}/man3/*

%files doc
%doc doc/* ldap-scripts

%files fivextra
%{prefix}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
