Summary: A tool for determining compilation options
Name: pkgconfig
Version: 0.27.1
%define base_release .3
Release: 1%{?dist}%{?base_release}
Epoch: 1
License: GPLv2+
URL: http://pkgconfig.freedesktop.org
Group: Development/Tools
Source:  http://www.freedesktop.org/software/pkgconfig/releases/pkg-config-%{version}.tar.gz
Source999: fivextra.tar.bz2
BuildRequires: glib2-devel

Provides: pkgconfig(pkg-config) = %{version}

%description
The pkgconfig tool determines compilation options. For each required
library, it reads the configuration file and outputs the necessary
compiler and linker flags.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -n pkg-config-%{version} -q -a 999

%build
%configure \
        --disable-shared \
        --with-installed-glib \
        --with-pc-path=%{_libdir}/pkgconfig:%{_datadir}/pkgconfig
make

%install
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pkgconfig

# we include this below, already
rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/pkg-config

# Steps to package the pkgconfig tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
pushd check
for dir in $( find . -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/$dir || true
done
popd

find $RPM_BUILD_ROOT%{fivdir}/%{name}/ -mindepth 2 -name 'Makefile*' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

%files
%doc AUTHORS README NEWS COPYING pkg-config-guide.html
%{_mandir}/*/*
%{_bindir}/*
%{_libdir}/pkgconfig
%{_datadir}/pkgconfig
%{_datadir}/aclocal/*

%files fivextra
%{prefix} 

%changelog
* Wed May 08 2013 baseuser@ibm.com
- Base-8.x spec file
