%define vermajor 1
%define verminor 5.5
%define version %{vermajor}.%{verminor}
%define libdir /%{_lib}
%define usrlibdir %{_prefix}/%{_lib}
%define libapivermajor 1
%define libapiversion %{libapivermajor}.4

# % define buildid .local

Summary: Linux Key Management Utilities
Name: keyutils
Version: %{version}
%define base_release .3
Release: 4%{?dist}%{?base_release}%{?buildid}
License: GPLv2+ and LGPLv2+
Group: System Environment/Base
ExclusiveOS: Linux
Url: http://people.redhat.com/~dhowells/keyutils/

Source0: http://people.redhat.com/~dhowells/keyutils/keyutils-%{version}.tar.bz2
Source999: fivextra.tar.bz2
Patch71509: bug-71509-use-relative-paths-for-devellib.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: glibc-kernheaders >= 2.4-9.1.92
Requires: keyutils-libs == %{version}-%{release}

%description
Utilities to control the kernel key management facility and to provide
a mechanism by which the kernel call back to user space to get a key
instantiated.

%package libs
Summary: Key utilities library
Group: System Environment/Base

%description libs
This package provides a wrapper library for the key management facility system
calls.

%package libs-devel
Summary: Development package for building Linux key management utilities
Group: System Environment/Base
Requires: keyutils-libs == %{version}-%{release}

%description libs-devel
This package provides headers and libraries for building key utilities.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch71509 -p1

%build
make   CC=%{__cc} \
	NO_ARLIB=1 \
	LIBDIR=/%{_lib} \
	USRLIBDIR=%{_libdir} \
	RELEASE=.%{release} \
	NO_GLIBC_KEYERR=1 \
	CFLAGS="-Wall $RPM_OPT_FLAGS -Werror"

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make   CC=%{__cc} \
	NO_ARLIB=1 \
	DESTDIR=$RPM_BUILD_ROOT \
	LIBDIR=/%{_lib} \
	USRLIBDIR=%{_libdir} \
	install

# Steps to package the keyutils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%post libs -p /sbin/ldconfig
%postun libs -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc README LICENCE.GPL
/sbin/*
/bin/*
/usr/share/keyutils
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man8/*
%config(noreplace) /etc/*

%files libs
%defattr(-,root,root,-)
%doc LICENCE.LGPL
%{libdir}/libkeyutils.so.%{libapiversion}
%{libdir}/libkeyutils.so.%{libapivermajor}

%files libs-devel
%defattr(-,root,root,-)
%{usrlibdir}/libkeyutils.so
%{_includedir}/*
%{_mandir}/man3/*

%files fivextra
%{prefix}

%changelog
* Tue May 14 2013 baseuser@ibm.com
- Base-8.x spec file
