# Base tzdata is noarch so define java_arch with uname
%define java_arch %(uname -m)

Summary: Timezone data
Name: tzdata
Version: 2013c
%define tzdata_version 2013c
%define tzcode_version 2013c
%define base_release .6
Release: 1%{?dist}%{?base_release}
License: Public Domain
Group: System Environment/Base
URL: https://www.iana.org/time-zones
Source0: ftp://ftp.iana.org/tz/releases/tzdata%{tzdata_version}.tar.gz
Source1: ftp://ftp.iana.org/tz/releases/tzcode%{tzcode_version}.tar.gz
Source999: fivextra.tar.bz2

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: gawk, glibc, perl
BuildRequires: ibm-java-%{java_arch}-sdk
BuildRequires: glibc-common >= 2.5.90-7
Conflicts: glibc-common <= 2.3.2-63
BuildArchitectures: noarch

%description
This package contains data files with rules for various timezones around
the world.

%package java
Summary: Timezone data for Java
Group: System Environment/Base
Source3: javazic.tar.gz
Patch100: javazic-fixup.patch
Patch101: javazic-exclusion-fix.patch

%description java
This package contains timezone information for use by Java runtimes.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: glibc-common
Requires: rpm

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -c -a 1 -a 999

mkdir javazic
tar zxf %{SOURCE3} -C javazic
pushd javazic
%patch100
%patch101

# Hack alert! sun.tools may be defined and installed in the
# VM. In order to guarantee that we are using IcedTea/OpenJDK
# for creating the zoneinfo files, rebase all the packages
# from "sun." to "rht.". Unfortunately, gcj does not support
# any of the -Xclasspath options, so we must go this route
# to ensure the greatest compatibility.
mv sun rht
find . -type f -name '*.java' -print0 \
    | xargs -0 -- sed -i -e 's:sun\.tools\.:rht.tools.:g' \
                         -e 's:sun\.util\.:rht.util.:g'
popd

%build
FILES="africa antarctica asia australasia europe northamerica southamerica
	pacificnew etcetera backward solar87 solar88 solar89"

mkdir zoneinfo/{,posix,right}
zic -y ./yearistype -d zoneinfo -L /dev/null -p America/New_York $FILES
zic -y ./yearistype -d zoneinfo/posix -L /dev/null $FILES
zic -y ./yearistype -d zoneinfo/right -L leapseconds $FILES

grep -v tz-art.htm tz-link.htm > tz-link.html

export JAVA_HOME="/opt/ibm/java-%{java_arch}-70"
export PATH="${PATH}:${JAVA_HOME}/bin"
pushd javazic
javac -source 1.5 -target 1.5 -classpath . `find . -name \*.java`
popd

java -classpath javazic/ rht.tools.javazic.Main -V %{version} \
  -d javazi \
  $FILES javazic/tzdata_jdk/gmt javazic/tzdata_jdk/jdk11_backward

%install
rm -fr $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT%{_datadir}
cp -prd zoneinfo $RPM_BUILD_ROOT%{_datadir}
install -p -m 644 zone.tab iso3166.tab $RPM_BUILD_ROOT%{_datadir}/zoneinfo
cp -prd javazi $RPM_BUILD_ROOT%{_datadir}/javazi

# Steps to package the tzdata tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_datadir}/zoneinfo
%doc README
%doc Theory
%doc tz-link.html

%files java
%defattr(-,root,root)
%{_datadir}/javazi

%files fivextra
%{prefix}

%changelog
* Wed Aug 21 2013 baseuser@ibm.com
- Base-8.x spec file
