Name:           libnih
Version:        1.0.2
%define base_release .2
Release:        8%{?dist}%{?base_release}
Summary:        Lightweight application development library

Group:          System Environment/Libraries
License:        GPLv2
URL:            https://launchpad.net/libnih
Source0:        http://launchpad.net/libnih/1.0/1.0.2/+download/libnih-1.0.2.tar.gz
Source999:      fivextra.tar.bz2
# don't use dirent.d_type (#562815)
Patch1:         libnih-file-isdir.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  autoconf >= 2.62
BuildRequires:  gettext >= 0.17
BuildRequires:  gettext-autopoint
BuildRequires:  automake >= 1.11
BuildRequires:  libtool >= 2.2.4
BuildRequires:  dbus-devel >= 1.2.16
BuildRequires:  expat >= 2.0.0
BuildRequires:  expat-devel >= 2.0.0

# Filter GLIBC_PRIVATE Requires:
%define __filter_GLIBC_PRIVATE 1


%description
libnih is a small library for C application development containing functions
that, despite its name, are not implemented elsewhere in the standard library
set.

libnih is roughly equivalent to other C libraries such as glib, except that its
focus is on a small size and intended for applications that sit very low in the
software stack, especially outside of /usr.


%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: dbus

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch1 -p1 -b .xfsdir


%build
%{?cross_build:export NIH_DBUS_TOOL=nih-dbus-tool}
sed -i 's:$(prefix)/lib:$(prefix)/%{_lib}:g' nih{,-dbus}/Makefile.am
autoreconf -i --force
%configure --disable-static --disable-rpath --libdir=/%{_lib}
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool
make %{?_smp_mflags}

# Build tests
# But have to exlude building of few tests for cross
%if 0%{?cross_build}
%define tests() tests=`find test_*.c -not -name 'test_demarshal*' -not -name 'test_interface*' -not -name 'test_marshal*' -not -name 'test_method*' -not -name 'test_property*' -not -name 'test_signal*'`
%else
%define tests() tests=`find test_*.c`
%endif

for dir in nih nih-dbus nih-dbus-tool; do pushd $dir/tests; %tests; cd ..;
for test in $tests; do test=${test%%.c}; make $test; done; popd; done

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig

# Steps to package the libnih tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find nih nih-dbus nih-dbus-tool -maxdepth 0 -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install $(find $dir/ -maxdepth 1 -type f -not -name '*.*' ) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/expected
for dir in $(find nih-dbus-tool/tests/expected)
do 
install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/expected || true 
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
#some tests fail in koji while pass in mock and local build
#to run make check use "--with check"
%if %{?_with_check:1}%{!?_with_check:0}
  make check
%endif


%clean
rm -rf $RPM_BUILD_ROOT


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%doc README
%doc AUTHORS
%doc ChangeLog
%doc COPYING
/%{_lib}/*.so.*

%files devel
%defattr(-,root,root,-)
%doc HACKING
%doc TODO
%{_mandir}/man1/nih-dbus-tool.1.gz
%{_bindir}/nih-dbus-tool
%{_includedir}/*
/%{_lib}/*.so
%{_libdir}/pkgconfig/*
%{_prefix}/share/aclocal/libnih.m4

%files fivextra
%{prefix}

%changelog
* Tue Jul 16 2013 baseuser@ibm.com
- Base-8.x spec file
