%global _hardened_build 1

Summary: The Point-to-Point Protocol daemon
Name: ppp
Version: 2.4.5
%define base_release .1
Release: 33%{?dist}%{?base_release}
License: BSD and LGPLv2+ and GPLv2+ and Public Domain
Group: System Environment/Daemons
URL: http://www.samba.org/ppp
Source0: ftp://ftp.samba.org/pub/ppp/ppp-%{version}.tar.gz
Source1: ppp-2.3.5-pamd.conf
Source2: ppp.logrotate
Source3: ppp-tmpfs.conf
Source999: fivextra.tar.bz2

# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2

Patch0: ppp-2.4.3-make.patch
Patch1: ppp-2.3.6-sample.patch
Patch2: ppp-2.4.2-libutil.patch
Patch3: ppp-2.4.1-varargs.patch
Patch4: ppp-2.4.4-lib64.patch
Patch7: ppp-2.4.2-pie.patch
Patch8: ppp-2.4.3-fix.patch
Patch9: ppp-2.4.3-fix64.patch
Patch11: ppp-2.4.2-change_resolv_conf.patch
Patch13: ppp-2.4.4-no_strip.patch
Patch17: ppp-2.4.2-pppoatm-make.patch
Patch19: ppp-2.4.3-local.patch
Patch20: ppp-2.4.3-ipv6-accept-remote.patch
Patch22: ppp-2.4.4-cbcp.patch
Patch23: ppp-2.4.2-dontwriteetc.patch
Patch24: ppp-2.4.4-fd_leak.patch
Patch25: ppp-2.4.5-var_run_ppp.patch
Patch26: ppp-2.4.5-manpg.patch
Patch27: ppp-2.4.5-eaptls-mppe-0.99.patch
Patch28: ppp-2.4.5-ppp_resolv.patch
Patch29: ppp-2.4.5-man.patch
Patch30: ppp-2.4.5-eth.patch
Patch31: ppp-2.4.5-lock.patch
Patch32: ppp-2.4.5-l2tp-multilink.patch
Patch33: ppp-2.4.5-radius-config.patch
Patch34: ppp-2.4.5-crypt.patch
Patch35: ppp-2.4.5-hardened.patch
Patch36: 0001-pppd-Eliminate-potential-integer-overflow-in-option-.patch

BuildRequires: pam-devel, libpcap-devel, openssl-devel, systemd
Requires: glibc >= 2.0.6, /etc/pam.d/system-auth, libpcap >= 14:0.8.3-6, systemd
Requires(pre): /usr/bin/getent
Requires(pre): /usr/sbin/groupadd

%description
The ppp package contains the PPP (Point-to-Point Protocol) daemon and
documentation for PPP support. The PPP protocol provides a method for
transmitting datagrams over serial point-to-point links. PPP is
usually used to dial in to an ISP (Internet Service Provider) or other
organization over a modem and phone line.

%package devel
Summary: Headers for ppp plugin development
Group: Development/Libraries

%description devel
This package contains the header files for building plugins for ppp.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup  -q -n %{name}-%{version} -a 999
%patch0 -p1 -b .make
%patch1 -p1 -b .sample
# patch 2 depends on the -lutil in patch 0
%patch2 -p1 -b .libutil
%patch3 -p1 -b .varargs
# patch 4 depends on the -lutil in patch 0
%patch4 -p1 -b .lib64
%patch7 -p1 -b .pie
%patch8 -p1 -b .fix
%patch9 -p1 -b .fix64
%patch11 -p1 -b .change_resolv_conf
#%patch13 -p1 -b .no_strip
%patch17 -p1 -b .atm-make
#%patch19 -p1 -b .local
%patch20 -p1 -b .ipv6cp
%patch22 -p1 -b .cbcp
%patch23 -p1 -b .dontwriteetc
%patch24 -p1 -b .fd_leak
%patch25 -p1 -b .var_run_ppp
%patch26 -p1 -b .manpg
%patch27 -p1 -b .eaptls
%patch28 -p1 -b .ppp_resolv
%patch29 -p1 -b .man
# fixes bz#682381 - hardcodes eth0
%patch30 -p1 -b .eth
# fixes bz#708260 - SELinux is preventing access on the file LCK..ttyUSB3
%patch31 -p1 -b .lock
%patch32 -p1 -b .l2tp-multilink
%patch33 -p1 -b .radius
%patch34 -p1 -b .crypt
%patch35 -p1 -b .hardened
%patch36 -p1 -b .cve-2014-3158

rm -f scripts/*.local
rm -f scripts/*.change_resolv_conf
rm -f scripts/*.usepeerdns-var_run_ppp_resolv
rm -f scripts/*.ppp_resolv
find . -type f -name "*.sample" | xargs rm -f

rm -f include/linux/if_pppol2tp.h

%build
#find . -name 'Makefile*' -print0 | xargs -0 perl -pi.no_strip -e "s: -s : :g"
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -fPIC -Wall"
%configure
make CC=%{__cc}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
export INSTROOT=$RPM_BUILD_ROOT
make install install-etcppp

chmod -R a+rX scripts
find scripts -type f | xargs chmod a-x
chmod 0755 $RPM_BUILD_ROOT/%{_libdir}/pppd/%{version}/*.so
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/pam.d
install -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/ppp

# Provide pointers for people who expect stuff in old places
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/ppp
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/ppp
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lock/ppp

install -d -m 755 $RPM_BUILD_ROOT%{_tmpfilesdir}
install -p -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_tmpfilesdir}/ppp.conf

# Logrotate script
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/ppp

# Steps to package the ppp tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 

%clean
rm -rf $RPM_BUILD_ROOT

%pre
getent group dip >/dev/null 2>&1 || groupadd -r -g 40 dip >/dev/null 2>&1 || :

%post
mkdir -p %{_localstatedir}/lock/ppp 2>&1 >/dev/null || :

%files
%defattr(-,root,root)
%{_sbindir}/chat
%{_sbindir}/pppd
%{_sbindir}/pppdump
%{_sbindir}/pppoe-discovery
%{_sbindir}/pppstats
%{_mandir}/man8/chat.8*
%{_mandir}/man8/pppd.8*
%{_mandir}/man8/pppdump.8*
%{_mandir}/man8/pppd-radattr.8*
%{_mandir}/man8/pppd-radius.8*
%{_mandir}/man8/pppstats.8*
%{_mandir}/man8/pppoe-discovery.8*
%{_libdir}/pppd
%dir %{_sysconfdir}/ppp
%dir %{_localstatedir}/run/ppp
%ghost %dir %{_localstatedir}/lock/ppp
%dir %{_sysconfdir}/logrotate.d
%attr(700, root, root) %dir %{_localstatedir}/log/ppp
%config(noreplace) %{_sysconfdir}/ppp/eaptls-client
%config(noreplace) %{_sysconfdir}/ppp/eaptls-server
%config(noreplace) %{_sysconfdir}/ppp/chap-secrets
%config(noreplace) %{_sysconfdir}/ppp/options
%config(noreplace) %{_sysconfdir}/ppp/pap-secrets
%config(noreplace) %{_sysconfdir}/pam.d/ppp
%config(noreplace) %{_sysconfdir}/logrotate.d/ppp
%{_tmpfilesdir}/ppp.conf
%doc FAQ README README.cbcp README.linux README.MPPE README.MSCHAP80 README.MSCHAP81 README.pwfd README.pppoe scripts sample README.eap-tls

%files devel
%defattr(-,root,root)
%{_includedir}/pppd
%doc PLUGINS

%files fivextra
%{prefix}

%changelog
* Fri Sep 12 2014 baseuser@ibm.com
- Base-8.x spec file
