Summary:        Utilities for configuring the linux ethernet bridge
Name:           bridge-utils
Version:        1.5
%define base_release .2
Release:        7%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:        GPLv2+
URL:            http://www.linuxfoundation.org/collaborate/workgroups/networking/bridge
Group:          System Environment/Base
Source:         http://downloads.sourceforge.net/bridge/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2
Patch0:         bridge-utils-1.5-fix-incorrect-command-in-manual.patch
Patch1:         bridge-utils-1.5-fix-error-message-for-incorrect-command.patch
Patch2:         bridge-utils-1.5-check-error-returns-from-write-to-sysfs.patch
Patch10:        bridge-utils-1.0.4-inc.patch
Patch11:        bridge-utils-1.5-linux_3.8.x.patch
BuildRequires:  libsysfs-devel autoconf
BuildRequires:  kernel-headers >= 2.6.16

%description
This package contains utilities for configuring the linux ethernet
bridge. The linux ethernet bridge can be used for connecting multiple
ethernet devices together. The connecting is fully transparent: hosts
connected to one ethernet device see hosts connected to the other
ethernet devices directly.

Install bridge-utils if you want to use the linux ethernet bridge.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch10 -p1
%patch11 -p1

%build
autoconf
%configure
make

pushd fivextra
make all
popd

%install
make DESTDIR=%{buildroot} SUBDIRS="brctl doc" install

# Steps to package the acpid tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%doc AUTHORS COPYING doc/FAQ doc/HOWTO
%{_sbindir}/brctl
%{_mandir}/man8/brctl.8*

%files fivextra
%{prefix}

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-8.x spec file
