%global mcpsource_install_dir mcpsource/%{name}-2.02.98-%{release}-source

%define device_mapper_version 1.02.77

%define enable_thin 1
%define enable_lvmetad 1
%define enable_cluster 1
%define enable_cmirror 1

%define systemd_version 189-3
%define dracut_version 002-18
%define util_linux_version 2.22.1
%define bash_version 4.0
%define corosync_version 1.99.9-1
%define dlm_version 3.99.1-1
%define libselinux_version 1.30.19-4
%define persistent_data_version 0.2.3-1

%if 0%{?rhel} || 0%{?base}
#  %ifnarch i686 x86_64
    %define enable_cluster 0
    %define enable_cmirror 0
#  %endif
%endif

%if %{enable_cluster}
  %define configure_cluster --with-cluster=internal --with-clvmd=corosync
  %if %{enable_cmirror}
    %define configure_cmirror --enable-cmirrord
  %endif
%else
    %define configure_cluster --with-cluster=internal --with-clvmd=none
%endif


# Do not reset Release to 1 unless both lvm2 and device-mapper 
# versions are increased together.

Summary: Userland logical volume management tools 
Name: lvm2
Version: 2.02.98
%define base_release .1
Release: 14%{?dist}%{?base_release}
License: GPLv2
Group: System Environment/Base
URL: http://sources.redhat.com/lvm2
Source0: ftp://sources.redhat.com/pub/lvm2/LVM2.%{version}.tgz
Source999: fivextra.tar.bz2
Patch0: lvm2-set-default-preferred_names.patch
Patch1: lvm2-enable-lvmetad-by-default.patch
Patch2: lvm2-2_02_99-python-remove-liblvm-object.patch
Patch3: lvm2-2_02_99-python-whitespace-and-conditional-cleanup.patch
Patch4: lvm2-2_02_99-python-update-example-to-work-with-lvm-object-removal.patch
Patch5: lvm2-2_02_99-python-implement-proper-refcounting-for-parent-objects.patch
Patch6: lvm2-2_02_99-properly-set-cookie_set-var-on-dm_task_set_cookie-call.patch
Patch7: lvm2-2_02_99-hardcode-use_lvmetad0-if-cluster-locking-used-and-issue-warning-msg.patch
Patch8: lvm2-2_02_99-init-lvmetad-lazily-to-avoid-early-socket-access-on-config-overrides.patch
Patch9: lvm2-2_02_99-various-updates-and-fixes-for-systemd-units.patch
Patch10: lvm2-2_02_99-exit-pvscan-cache-immediately-if-cluster-locking-used-or-lvmetad-not-used.patch
Patch11: lvm2-2_02_99-skip-mlocking-verctors-on-arm-arch.patch
Patch12: lvm2-2_02_99-fix-autoactivation-to-not-autoactivate-vg-lv-on-each-pv-change.patch
Patch13: lvm2-2_02_99-synchronize-with-udev-in-pvscan-cache-and-fix-dangling-udev_sync-cookies.patch
Patch14: lvm2-2_02_99-also-autoactivate-on-coldplug.patch
Patch15: lvm2-2_02_99-fire-pvscan-cache-on-change-event-for-md-devs.patch
Patch16: lvm2-2_02_99-various-thin-support-related-fixes.patch
Patch17: lvm2-2_02_99-fix-lv_is_active-in-lvcreate.patch
Patch18: lvm2-2_02_99-fix-crash-in-pvscan-cache-aay-triggered-by-non-mda-pv.patch
Patch19: lvm2-2_02_99-avoid-global-lock-in-pvs-when-lvmetad-is-in-use.patch
Patch20: lvm2-2_02_99-fix-possible-deadlock-in-lvmetad-for-parallel-update-and-query.patch
Patch21: lvm2-2_02_99-fix-possible-race-in-lvmetad-remove_metadata.patch
Patch22: lvm2-2_02_99-lvmetad-fix-a-race-in-metadata-update.patch
Patch23: lvm2-2_02_99-fix-handling-of-reappeared-and-missing-pvs-in-lvmetad.patch
Patch24: lvm2-2_02_99-fix-blkdeactivate-handling-of-nested-mountpoints-and-mangled-mount-paths.patch
Patch25: lvm2-2_02_99-add-dm-disable-udev-env-var-and-fix-noudevsync-arg.patch
Patch26: lvm2-2_02_99-fix-premature-dm-version-checking-which-caused-useless-mapper-control-access.patch
Patch27: lvm2-2_02_99-close-dmeventd-fifo-fds-on-exec.patch
Patch28: lvm2-2_02_99-fix-dmsetup-splitname-to-not-fail-if-used-without-c-switch.patch
Patch29: lvm2-2_02_99-use-log_debug_err-msg-severity-for-activation-generator.patch
Patch30: lvm2-2_02_99-respect-global-filter-in-pvscan-cache-with-a-device.patch
Patch31: lvm2-2_02_100-fix-segfault-if-global_filter-incorrect.patch
Patch32: lvm2-2_02_100-fix-mda-offset-size-overflow-4g-with-lvmetad.patch
Patch33: lvm2-2_02_99-fix-use-of-too-big-memchunks-when-communicating-with-lvmetad.patch
Patch34: lvm2-2_02_99-fix-dmeventd-return-value-on-show-version.patch
Patch35: lvm2-2_02_101-fix-ignored-lvmetad-update-on-loop-device-configuration.patch
Patch36: lvm2-2_02_104-fix-possible-lvmetad-races-and-deadlocks.patch
Patch37: lvm2-2_02_105-compile-and-link-executables-with-relro-and-pie.patch
Patch38: lvm2-2_02_105-lvmdump-follow-symbolic-links-in-etc-lvm.patch
Patch39: lvm2-2_02_105-lvm2app-save-off-and-restore-umask-values.patch

BuildRequires: libselinux-devel >= %{libselinux_version}, libsepol-devel
BuildRequires: ncurses-devel
BuildRequires: readline-devel
%if %{enable_cluster}
BuildRequires: corosynclib-devel >= %{corosync_version}
BuildRequires: dlm-devel >= %{dlm_version}
%endif
BuildRequires: module-init-tools
BuildRequires: pkgconfig
BuildRequires: systemd-devel
BuildRequires: systemd-units
%{!?cross_build:BuildRequires: python2-devel}
%{!?cross_build:BuildRequires: python-setuptools}
Requires: %{name}-libs = %{version}-%{release}
Requires: bash >= %{bash_version}
Requires(post): systemd-units >= %{systemd_version}, systemd-sysv
Requires(preun): systemd-units >= %{systemd_version}
Requires(postun): systemd-units >= %{systemd_version}
Requires: module-init-tools
%if %{enable_thin}
Requires: device-mapper-persistent-data >= %{persistent_data_version}
%endif

%description
LVM2 includes all of the support for handling read/write operations on
physical volumes (hard disks, RAID-Systems, magneto optical, etc.,
multiple devices (MD), see mdadd(8) or even loop devices, see
losetup(8)), creating volume groups (kind of virtual disks) from one
or more physical volumes and creating one or more logical volumes
(kind of logical partitions) in volume groups.

%prep
%setup -q -n LVM2.%{version} -a 999
%patch0 -p1 -b .preferred_names
%patch1 -p1 -b .enable_lvmetad
%patch2 -p1 -b .python_liblvm_object
%patch3 -p1 -b .python_cleanup
%patch4 -p1 -b .python_fix_example
%patch5 -p1 -b .python_refcounting
%patch6 -p1 -b .cookie_flags
%patch7 -p1 -b .cluster_lvmetad
%patch8 -p1 -b .lvmetad_lazy_init
%patch9 -p1 -b .systemd_fixes
%patch10 -p1 -b .pvscan_immediate
%patch11 -p1 -b .arm_vectors
%patch12 -p1 -b .autoactivation
%patch13 -p1 -b .dangling_cookies
%patch14 -p1 -b .coldplug
%patch15 -p1 -b .autoactivation_on_md
%patch16 -p1 -b .various_thin_fixes
%patch17 -p1 -b .lv_is_active
%patch18 -p1 -b .pvscan_cache_aay_crash
%patch19 -p1 -b .avoid_global_lock
%patch20 -p1 -b .lvmetad_deadlock
%patch21 -p1 -b .lvmetad_race_on_remove
%patch22 -p1 -b .lvmetad_race_on_update
%patch23 -p1 -b .lvmetad_missing_reappear_pv
%patch24 -p1 -b .blkdeactivate
%patch25 -p1 -b .dm_disable_udev
%patch26 -p1 -b .premature_dm_version
%patch27 -p1 -b .dmeventd_fd_cloexec
%patch28 -p1 -b .dmsetup_splitname
%patch29 -p1 -b .activation_generator_log
%patch30 -p1 -b .pvscan_global_filter
%patch31 -p1 -b .segfault_global_filter
%patch32 -p1 -b .lvmetad_mda_overflow
%patch33 -p1 -b .lvmetad_mem_chunks
%patch34 -p1 -b .dmeventd_version
%patch35 -p1 -b .lvmetad_loop_dev
%patch36 -p1 -b .lvmetad_races_deadlocks
%patch37 -p1 -b .relro_pie
%patch38 -p1 -b .lvmdump_follow_symlinks
%patch39 -p1 -b .lvm2app_umask

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%build
%define _default_pid_dir /run
%define _default_dm_run_dir /run
%define _default_run_dir /run/lvm
%define _default_locking_dir /run/lock/lvm

%define _udevdir %{_prefix}/lib/udev/rules.d
%define _tmpfilesdir %{_prefix}/lib/tmpfiles.d

%define configure_udev --with-udevdir=%{_udevdir} --enable-udev_sync

%if %{enable_thin}
%define configure_thin --with-thin=internal --with-thin-check=%{_sbindir}/thin_check
%endif

%if %{enable_lvmetad}
%define configure_lvmetad --enable-lvmetad
%endif

%if 0%{?cross_build}
export UDEV_CFLAGS="-I%{_sysroot}%{_includedir}"
export UDEV_LIBS="-L%{_sysroot}%{_libdir} -ludev"
%endif

%configure --with-default-dm-run-dir=%{_default_dm_run_dir} --with-default-run-dir=%{_default_run_dir} --with-default-pid-dir=%{_default_pid_dir} --with-default-locking-dir=%{_default_locking_dir} --with-usrlibdir=%{_libdir} --enable-lvm1_fallback --enable-fsadm --with-pool=internal --with-user= --with-group= --with-device-uid=0 --with-device-gid=6 --with-device-mode=0660 --enable-pkgconfig --enable-applib --enable-cmdlib %{!?cross_build:--enable-python-bindings} --enable-dmeventd %{?configure_cluster} %{?configure_cmirror} %{?configure_udev} %{?configure_thin} %{?configure_lvmetad}

make CC=%{__cc} %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT
make install_system_dirs DESTDIR=$RPM_BUILD_ROOT
make install_initscripts DESTDIR=$RPM_BUILD_ROOT
make install_systemd_units DESTDIR=$RPM_BUILD_ROOT
make install_systemd_generators DESTDIR=$RPM_BUILD_ROOT
make install_tmpfiles_configuration DESTDIR=$RPM_BUILD_ROOT

# Steps to package the lvm2 tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
%systemd_post blk-availability.service lvm2-monitor.service
%if %{enable_lvmetad}
%systemd_post lvm2-lvmetad.socket
%endif

%preun
%systemd_preun blk-availability.service lvm2-monitor.service
%if %{enable_lvmetad}
%systemd_preun lvm2-lvmetad.service lvm2-lvmetad.socket
%endif

%postun
%systemd_postun_with_restart lvm2-monitor.service
%if %{enable_lvmetad}
%systemd_postun_with_restart lvm2-lvmetad.service
%endif

%triggerun -- %{name} < 2.02.86-2
%{_bindir}/systemd-sysv-convert --save lvm2-monitor >/dev/null 2>&1 || :
/bin/systemctl --no-reload enable lvm2-monitor.service > /dev/null 2>&1 || :
/sbin/chkconfig --del lvm2-monitor > /dev/null 2>&1 || :
/bin/systemctl try-restart lvm2-monitor.service > /dev/null 2>&1 || :

%files
%defattr(-,root,root,-)
%doc COPYING COPYING.LIB INSTALL README VERSION WHATS_NEW
%doc doc/lvm_fault_handling.txt
%{_sbindir}/blkdeactivate
%{_sbindir}/fsadm
%{_sbindir}/lvchange
%{_sbindir}/lvconvert
%{_sbindir}/lvcreate
%{_sbindir}/lvdisplay
%{_sbindir}/lvextend
%{_sbindir}/lvm
%{_sbindir}/lvmchange
%{_sbindir}/lvmdiskscan
%{_sbindir}/lvmdump
%{_sbindir}/lvmsadc
%{_sbindir}/lvmsar
%{_sbindir}/lvreduce
%{_sbindir}/lvremove
%{_sbindir}/lvrename
%{_sbindir}/lvresize
%{_sbindir}/lvs
%{_sbindir}/lvscan
%{_sbindir}/pvchange
%{_sbindir}/pvck
%{_sbindir}/pvcreate
%{_sbindir}/pvdisplay
%{_sbindir}/pvmove
%{_sbindir}/pvremove
%{_sbindir}/pvresize
%{_sbindir}/pvs
%{_sbindir}/pvscan
%{_sbindir}/vgcfgbackup
%{_sbindir}/vgcfgrestore
%{_sbindir}/vgchange
%{_sbindir}/vgck
%{_sbindir}/vgconvert
%{_sbindir}/vgcreate
%{_sbindir}/vgdisplay
%{_sbindir}/vgexport
%{_sbindir}/vgextend
%{_sbindir}/vgimport
%{_sbindir}/vgimportclone
%{_sbindir}/vgmerge
%{_sbindir}/vgmknodes
%{_sbindir}/vgreduce
%{_sbindir}/vgremove
%{_sbindir}/vgrename
%{_sbindir}/vgs
%{_sbindir}/vgscan
%{_sbindir}/vgsplit
%{_sbindir}/lvmconf
%if %{enable_lvmetad}
%{_sbindir}/lvmetad
%endif
%{_mandir}/man5/lvm.conf.5.gz
%{_mandir}/man8/blkdeactivate.8.gz
%{_mandir}/man8/fsadm.8.gz
%{_mandir}/man8/lvchange.8.gz
%{_mandir}/man8/lvconvert.8.gz
%{_mandir}/man8/lvcreate.8.gz
%{_mandir}/man8/lvdisplay.8.gz
%{_mandir}/man8/lvextend.8.gz
%{_mandir}/man8/lvm.8.gz
%{_mandir}/man8/lvmchange.8.gz
%{_mandir}/man8/lvmconf.8.gz
%{_mandir}/man8/lvmdiskscan.8.gz
%{_mandir}/man8/lvmdump.8.gz
%{_mandir}/man8/lvmsadc.8.gz
%{_mandir}/man8/lvmsar.8.gz
%{_mandir}/man8/lvreduce.8.gz
%{_mandir}/man8/lvremove.8.gz
%{_mandir}/man8/lvrename.8.gz
%{_mandir}/man8/lvresize.8.gz
%{_mandir}/man8/lvs.8.gz
%{_mandir}/man8/lvscan.8.gz
%{_mandir}/man8/pvchange.8.gz
%{_mandir}/man8/pvck.8.gz
%{_mandir}/man8/pvcreate.8.gz
%{_mandir}/man8/pvdisplay.8.gz
%{_mandir}/man8/pvmove.8.gz
%{_mandir}/man8/pvremove.8.gz
%{_mandir}/man8/pvresize.8.gz
%{_mandir}/man8/pvs.8.gz
%{_mandir}/man8/pvscan.8.gz
%{_mandir}/man8/vgcfgbackup.8.gz
%{_mandir}/man8/vgcfgrestore.8.gz
%{_mandir}/man8/vgchange.8.gz
%{_mandir}/man8/vgck.8.gz
%{_mandir}/man8/vgconvert.8.gz
%{_mandir}/man8/vgcreate.8.gz
%{_mandir}/man8/vgdisplay.8.gz
%{_mandir}/man8/vgexport.8.gz
%{_mandir}/man8/vgextend.8.gz
%{_mandir}/man8/vgimport.8.gz
%{_mandir}/man8/vgimportclone.8.gz
%{_mandir}/man8/vgmerge.8.gz
%{_mandir}/man8/vgmknodes.8.gz
%{_mandir}/man8/vgreduce.8.gz
%{_mandir}/man8/vgremove.8.gz
%{_mandir}/man8/vgrename.8.gz
%{_mandir}/man8/vgs.8.gz
%{_mandir}/man8/vgscan.8.gz
%{_mandir}/man8/vgsplit.8.gz
%{_udevdir}/11-dm-lvm.rules
%if %{enable_lvmetad}
%{_mandir}/man8/lvmetad.8.gz
%{_udevdir}/69-dm-lvm-metad.rules
%endif
%dir %{_sysconfdir}/lvm
%ghost %{_sysconfdir}/lvm/cache/.cache
%config(noreplace) %verify(not md5 mtime size) %{_sysconfdir}/lvm/lvm.conf
%dir %{_sysconfdir}/lvm/backup
%dir %{_sysconfdir}/lvm/cache
%dir %{_sysconfdir}/lvm/archive
%dir %{_default_locking_dir}
%dir %{_default_run_dir}
%{_tmpfilesdir}/%{name}.conf
%{_unitdir}/blk-availability.service
%{_unitdir}/lvm2-monitor.service
%{_prefix}/lib/systemd/system-generators/lvm2-activation-generator
%if %{enable_lvmetad}
%{_unitdir}/lvm2-lvmetad.socket
%{_unitdir}/lvm2-lvmetad.service
%endif

##############################################################################
# Library and Development subpackages
##############################################################################
%package devel
Summary: Development libraries and headers
Group: Development/Libraries
License: LGPLv2
Requires: %{name} = %{version}-%{release}
Requires: device-mapper-devel >= %{device_mapper_version}-%{release}
Requires: device-mapper-event-devel >= %{device_mapper_version}-%{release}
Requires: pkgconfig

%description devel
This package contains files needed to develop applications that use
the lvm2 libraries.

%files devel
%defattr(-,root,root,-)
%{_libdir}/liblvm2app.so
%{_libdir}/liblvm2cmd.so
%{_includedir}/lvm2app.h
%{_includedir}/lvm2cmd.h
%{_libdir}/pkgconfig/lvm2app.pc
%{_libdir}/libdevmapper-event-lvm2.so

%package libs
Summary: Shared libraries for lvm2
License: LGPLv2
Group: System Environment/Libraries
Requires: device-mapper-event >= %{device_mapper_version}-%{release}

%description libs
This package contains shared lvm2 libraries for applications.

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%files libs
%defattr(-,root,root,-)
%attr(755,root,root) %{_libdir}/liblvm2app.so.*
%attr(755,root,root) %{_libdir}/liblvm2cmd.so.*
%attr(755,root,root) %{_libdir}/libdevmapper-event-lvm2.so.*
%dir %{_libdir}/device-mapper
%{_libdir}/device-mapper/libdevmapper-event-lvm2mirror.so
%{_libdir}/device-mapper/libdevmapper-event-lvm2snapshot.so
%{_libdir}/device-mapper/libdevmapper-event-lvm2raid.so
%{_libdir}/libdevmapper-event-lvm2mirror.so
%{_libdir}/libdevmapper-event-lvm2snapshot.so
%{_libdir}/libdevmapper-event-lvm2raid.so

%if %{enable_thin}
%{_libdir}/libdevmapper-event-lvm2thin.so
%{_libdir}/device-mapper/libdevmapper-event-lvm2thin.so
%endif

%if ! 0%{?cross_build}
%package python-libs
Summary: Python module to access LVM
License: LGPLv2
Group: Development/Libraries
Provides: python-lvm = %{version}-%{release}
Obsoletes: python-lvm < 2.02.98-2
Requires: %{name}-libs = %{version}-%{release}

%description python-libs
Python module to allow the creation and use of LVM
logical volumes, physical volumes, and volume groups.

%files python-libs
%{python_sitearch}/*
%endif # not cross_build

##############################################################################
# Cluster subpackage
##############################################################################
%if %{enable_cluster}

%package cluster
Summary: Cluster extensions for userland logical volume management tools
License: GPLv2
Group: System Environment/Base
Requires: lvm2 >= %{version}-%{release}
Requires(post): chkconfig
Requires(preun): chkconfig
Requires(preun): device-mapper >= %{device_mapper_version}
Requires(preun): lvm2 >= 2.02
Requires: corosync >= %{corosync_version}
Requires: dlm >= %{dlm_version}

%description cluster

Extensions to LVM2 to support clusters.

%post cluster
/sbin/chkconfig --add clvmd

if [ "$1" -gt "1" ] ; then
	/usr/sbin/clvmd -S >/dev/null 2>&1 || :
fi

%preun cluster
if [ "$1" = 0 ]; then
	/sbin/chkconfig --del clvmd
	/sbin/lvmconf --disable-cluster
fi

%files cluster
%defattr(-,root,root,-)
%attr(755,root,root) /usr/sbin/clvmd
%{_mandir}/man8/clvmd.8.gz
%{_sysconfdir}/rc.d/init.d/clvmd

%endif

##############################################################################
# Cluster mirror subpackage
##############################################################################
%if %{enable_cluster}
%if %{enable_cmirror}

%package -n cmirror
Summary: Daemon for device-mapper-based clustered mirrors
Group: System Environment/Base
Requires(post): chkconfig
Requires(preun): chkconfig
Requires: corosync >= %{corosync_version}
Requires: device-mapper >= %{device_mapper_version}-%{release}

%description -n cmirror
Daemon providing device-mapper-based mirrors in a shared-storage cluster.

%post -n cmirror
/sbin/chkconfig --add cmirrord

%preun -n cmirror
if [ "$1" = 0 ]; then
	/sbin/chkconfig --del cmirrord
fi

%files -n cmirror
%defattr(-,root,root,-)
%attr(755,root,root) /usr/sbin/cmirrord
%{_mandir}/man8/cmirrord.8.gz
%{_sysconfdir}/rc.d/init.d/cmirrord

%endif
%endif

##############################################################################
# Legacy SysV init subpackage
##############################################################################
%package sysvinit
Summary: SysV style init script for LVM2.
Group: System Environment/Base
Requires: %{name} = %{version}-%{release}
Requires: initscripts

%description sysvinit
SysV style init script for LVM2. It needs to be installed only if systemd
is not used as the system init process.

%files sysvinit
%{_sysconfdir}/rc.d/init.d/blk-availability
%{_sysconfdir}/rc.d/init.d/lvm2-monitor
%if %{enable_lvmetad}
%{_sysconfdir}/rc.d/init.d/lvm2-lvmetad
%endif

##############################################################################
# Device-mapper subpackages
##############################################################################
%package -n device-mapper
Summary: Device mapper utility
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
License: GPLv2
Group: System Environment/Base
URL: http://sources.redhat.com/dm
Requires: device-mapper-libs = %{device_mapper_version}-%{release}
Requires: util-linux >= %{util_linux_version}
Requires: systemd >= %{systemd_version}
# We need dracut to install required udev rules if udev_sync
# feature is turned on so we don't lose required notifications.
Conflicts: dracut < %{dracut_version}

%description -n device-mapper
This package contains the supporting userspace utility, dmsetup,
for the kernel device-mapper.

%files -n device-mapper
%defattr(-,root,root,-)
%doc COPYING COPYING.LIB WHATS_NEW_DM VERSION_DM README INSTALL
%attr(755,root,root) %{_sbindir}/dmsetup
%{_mandir}/man8/dmsetup.8.gz
%doc udev/12-dm-permissions.rules
%{_udevdir}/10-dm.rules
%{_udevdir}/13-dm-disk.rules
%{_udevdir}/95-dm-notify.rules

%package -n device-mapper-devel
Summary: Development libraries and headers for device-mapper
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
License: LGPLv2
Group: Development/Libraries
Requires: device-mapper = %{device_mapper_version}-%{release}
Requires: pkgconfig

%description -n device-mapper-devel
This package contains files needed to develop applications that use
the device-mapper libraries.

%files -n device-mapper-devel
%defattr(-,root,root,-)
%{_libdir}/libdevmapper.so
%{_includedir}/libdevmapper.h
%{_libdir}/pkgconfig/devmapper.pc

%package -n device-mapper-libs
Summary: Device-mapper shared library
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
License: LGPLv2
Group: System Environment/Libraries
Requires: device-mapper = %{device_mapper_version}-%{release}

%description -n device-mapper-libs
This package contains the device-mapper shared library, libdevmapper.

%post -n device-mapper-libs -p /sbin/ldconfig

%postun -n device-mapper-libs -p /sbin/ldconfig

%files -n device-mapper-libs
%attr(755,root,root) %{_libdir}/libdevmapper.so.*

%package -n device-mapper-event
Summary: Device-mapper event daemon
Group: System Environment/Base
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
Requires: device-mapper = %{device_mapper_version}-%{release}
Requires: device-mapper-event-libs = %{device_mapper_version}-%{release}
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

%description -n device-mapper-event
This package contains the dmeventd daemon for monitoring the state
of device-mapper devices.

%post -n device-mapper-event
%systemd_post dm-event.socket

%preun -n device-mapper-event
%systemd_preun dm-event.service dm-event.socket

%postun -n device-mapper-event
/bin/systemctl daemon-reload > /dev/null 2>&1 || :
if [ $1 -ge 1 ]; then
	/bin/systemctl reload dm-event.service > /dev/null 2>&1 || :
fi

%files -n device-mapper-event
%defattr(-,root,root,-)
%{_sbindir}/dmeventd
%{_mandir}/man8/dmeventd.8.gz
%{_unitdir}/dm-event.socket
%{_unitdir}/dm-event.service

%package -n device-mapper-event-libs
Summary: Device-mapper event daemon shared library
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
License: LGPLv2
Group: System Environment/Libraries

%description -n device-mapper-event-libs
This package contains the device-mapper event daemon shared library,
libdevmapper-event.

%post -n device-mapper-event-libs -p /sbin/ldconfig

%postun -n device-mapper-event-libs -p /sbin/ldconfig

%files -n device-mapper-event-libs
%attr(755,root,root) %{_libdir}/libdevmapper-event.so.*

%package -n device-mapper-event-devel
Summary: Development libraries and headers for the device-mapper event daemon
Version: %{device_mapper_version}
%define base_release .1
Release: %{release}
License: LGPLv2
Group: Development/Libraries
Requires: device-mapper-event = %{device_mapper_version}-%{release}
Requires: pkgconfig

%description -n device-mapper-event-devel
This package contains files needed to develop applications that use
the device-mapper event library.

%files -n device-mapper-event-devel
%defattr(-,root,root,-)
%{_libdir}/libdevmapper-event.so
%{_includedir}/libdevmapper-event.h
%{_libdir}/pkgconfig/devmapper-event.pc


%files fivextra
%{prefix}
 
%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
