# Base disable python3 for now
# global with_python3 1
%global short_name psutil

# Filter Python modules from Provides
%{?filter_setup:
%filter_provides_in %{python_sitearch}/.*\.so$
%filter_setup
}

Name:           python-psutil
Version:        1.2.1
%define base_release .4
Release:        2%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        A process and system utilities module for Python

Group:          Development/Languages
License:        BSD
URL:            http://psutil.googlecode.com/
Source0:        https://pypi.python.org/packages/source/p/%{short_name}/%{short_name}-%{version}.tar.gz

BuildRequires:  python2-devel
%if 0%{?with_python3}
BuildRequires:  python3-devel
%endif

%description
psutil is a module providing an interface for retrieving information on all
running processes and system utilization (CPU, memory, disks, network, users) in
a portable way by using Python, implementing many functionalities offered by
command line tools such as: ps, top, df, kill, free, lsof, free, netstat,
ifconfig, nice, ionice, iostat, iotop, uptime, pidof, tty, who, taskset, pmap.


%if 0%{?with_python3}
%package -n python3-psutil
Summary:        A process and system utilities module for Python 3
Group:          Development/Languages

%description -n python3-psutil
psutil is a module providing an interface for retrieving information on all
running processes and system utilization (CPU, memory, disks, network, users) in
a portable way by using Python 3, implementing many functionalities offered by
command line tools such as: ps, top, df, kill, free, lsof, free, netstat,
ifconfig, nice, ionice, iostat, iotop, uptime, pidof, tty, who, taskset, pmap.
%endif


%prep
%setup -q -n %{short_name}-%{version}

# Remove shebangs
for file in psutil/*.py; do
  sed -i.orig -e 1d $file && \
  touch -r $file.orig $file && \
  rm $file.orig
done

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif


%build
CFLAGS=$RPM_OPT_FLAGS %{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
CFLAGS=$RPM_OPT_FLAGS %{__python3} setup.py build
popd
%endif


%install
%{__python} setup.py install \
  --skip-build \
  --root $RPM_BUILD_ROOT

# Fix permissions
chmod 0755 $RPM_BUILD_ROOT%{python_sitearch}/*.so

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install \
  --skip-build \
  --root $RPM_BUILD_ROOT
popd

# Fix permissions
chmod 0755 $RPM_BUILD_ROOT%{python3_sitearch}/*.so
%endif

 
%files
%doc CREDITS HISTORY LICENSE README
%{python_sitearch}/%{short_name}/
%{python_sitearch}/*.egg-info
%{python_sitearch}/*.so


%if 0%{?with_python3}
%files -n python3-psutil
%doc CREDITS HISTORY LICENSE README
%{python3_sitearch}/%{short_name}/
%{python3_sitearch}/*.egg-info
%{python3_sitearch}/*.so
%endif


%changelog
* Thu Oct 24 2013 baseuser@ibm.com
- Base-8.x spec file
