%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
Summary:        A simple lightweight interface to Amazon Web Services
Name:           python-boto
Version:        2.13.3
%define base_release .1
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License:        MIT
Group:          Development/Languages
URL:            https://github.com/boto/boto
Source:         http://pypi.python.org/packages/source/b/boto/boto-%{version}.tar.gz
BuildRequires:  python-devel >= 2.5, python-setuptools-devel
BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

# Needed for euca-register --virtualization-type, requested by rel-eng
# https://github.com/boto/boto/pull/1733
Patch1:         boto-2.13.3-virttype.patch
# Fix auto-scaling get_all_adjustment_types
# https://github.com/boto/boto/pull/1538
Patch2:         boto-2.9.9-adjtype.patch
# Fix auto-scaling PropagateAtLaunch parsing
# https://bugzilla.redhat.com/show_bug.cgi?id=1011682
# https://github.com/boto/boto/pull/1739
Patch3:         boto-2.13.3-propagateatlaunch.patch

%description
Boto is a Python package that provides interfaces to Amazon Web Services.
It supports S3 (Simple Storage Service), SQS (Simple Queue Service) via
the REST API's provided by those services and EC2 (Elastic Compute Cloud)
via the Query API. The goal of boto is to provide a very simple, easy to
use, lightweight wrapper around the Amazon services.

%prep
%setup -q -n boto-%{version}
%patch1 -p1
%patch2 -p1
%patch3 -p1

rm -r boto.egg-info

%build
%{__python} setup.py build

%install
%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT

%files
%{_bindir}/asadmin
%{_bindir}/bundle_image
%{_bindir}/cfadmin
%{_bindir}/cq
%{_bindir}/cwutil
%{_bindir}/dynamodb_dump
%{_bindir}/dynamodb_load
%{_bindir}/elbadmin
%{_bindir}/fetch_file
%{_bindir}/glacier
%{_bindir}/instance_events
%{_bindir}/kill_instance
%{_bindir}/launch_instance
%{_bindir}/list_instances
%{_bindir}/lss3
%{_bindir}/mturk
%{_bindir}/pyami_sendmail
%{_bindir}/route53
%{_bindir}/s3put
%{_bindir}/sdbadmin
%{_bindir}/taskadmin
%{python_sitelib}/boto
%{python_sitelib}/boto*.egg-info

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
