Summary: NFS utilities and supporting clients and daemons for the kernel NFS server
Name: nfs-utils
URL: http://sourceforge.net/projects/nfs
Version: 1.2.8
%define base_release .1
Release: 6.0%{?dist}%{?base_release}
Epoch: 1

# group all 32bit related archs
%define all_32bit_archs i386 i486 i586 i686 athlon ppc sparcv9

Source0: http://sourceforge.net/projects/nfs/files/nfs-utils/%{version}/%{name}-%{version}.tar.bz2

Source9: id_resolver.conf
Source10: nfs.sysconfig
Source11: nfs-lock.service
Source12: nfs-secure.service
Source13: nfs-secure-server.service
Source14: nfs-server.service
Source15: nfs-blkmap.service
Source16: nfs-rquotad.service
Source17: nfs-mountd.service
Source18: nfs-idmap.service
Source19: nfs.target
%define nfs_services %{SOURCE11} %{SOURCE12} %{SOURCE13} %{SOURCE14} %{SOURCE15} %{SOURCE16} %{SOURCE17} %{SOURCE18} %{SOURCE19}
# 
# Services that need to be restarted.
#
%define nfs_start_services %{SOURCE11} %{SOURCE12} %{SOURCE13} %{SOURCE14} %{SOURCE15} %{SOURCE18} %{SOURCE19}
 
Source20: var-lib-nfs-rpc_pipefs.mount
Source21: proc-fs-nfsd.mount
%define nfs_automounts %{SOURCE20} %{SOURCE21}

Source50: nfs-lock.preconfig
Source51: nfs-server.preconfig
Source52: nfs-server.postconfig
Source999: fivextra.tar.bz2
%define nfs_configs %{SOURCE50} %{SOURCE51} %{SOURCE52} 

Patch001: nfs-utils.1.2.9-rc6.patch

Patch100: nfs-utils-1.2.1-statdpath-man.patch
Patch101: nfs-utils-1.2.1-exp-subtree-warn-off.patch
Patch102: nfs-utils-1.2.3-sm-notify-res_init.patch
Patch103: nfs-utils-1.2.5-idmap-errmsg.patch

Group: System Environment/Daemons
Provides: exportfs    = %{epoch}:%{version}-%{release}
Provides: nfsstat     = %{epoch}:%{version}-%{release}
Provides: showmount   = %{epoch}:%{version}-%{release}
Provides: rpcdebug    = %{epoch}:%{version}-%{release}
Provides: rpc.idmapd  = %{epoch}:%{version}-%{release}
Provides: rpc.mountd  = %{epoch}:%{version}-%{release}
Provides: rpc.nfsd    = %{epoch}:%{version}-%{release}
Provides: rpc.statd   = %{epoch}:%{version}-%{release}
Provides: rpc.gssd    = %{epoch}:%{version}-%{release}
Provides: rpc.svcgssd = %{epoch}:%{version}-%{release}
Provides: mount.nfs   = %{epoch}:%{version}-%{release}
Provides: mount.nfs4  = %{epoch}:%{version}-%{release}
Provides: umount.nfs  = %{epoch}:%{version}-%{release}
Provides: umount.nfs4 = %{epoch}:%{version}-%{release}
Provides: sm-notify   = %{epoch}:%{version}-%{release}
Provides: start-statd = %{epoch}:%{version}-%{release}

License: MIT and GPLv2 and GPLv2+ and BSD
Requires: rpcbind, sed, gawk, sh-utils, fileutils, textutils, grep
Requires: kmod, keyutils, quota
BuildRequires: libevent-devel libcap-devel
BuildRequires: libnfsidmap-devel libtirpc-devel libblkid-devel
BuildRequires: krb5-libs >= 1.4 autoconf >= 2.57 openldap-devel >= 2.2
BuildRequires: automake, libtool, glibc-headers, device-mapper-devel
BuildRequires: krb5-devel, tcp_wrappers-devel, libmount-devel
BuildRequires: %{!?fedora:fedfs-utils-devel >= 0.8.0-7,} sqlite-devel
Requires(pre): shadow-utils >= 4.0.3-25
Requires(pre): /sbin/chkconfig /sbin/nologin
Requires: libnfsidmap libevent
Requires: libtirpc >= 0.2.3-1 libblkid libcap libmount
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

%description
The nfs-utils package provides a daemon for the kernel NFS server and
related tools, which provides a much higher level of performance than the
traditional Linux NFS server used by most users.

This package also contains the showmount program.  Showmount queries the
mount daemon on a remote host for information about the NFS (Network File
System) server on the remote host.  For example, showmount can display the
clients which are mounted on that host.

This package also contains the mount.nfs and umount.nfs program.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999

%patch001 -p1

%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1

# Remove .orig files
find . -name "*.orig" | xargs rm -f

%build

%ifarch s390 s390x sparcv9 sparc64
PIE="-fPIE"
%else
PIE="-fpie"
%endif
export PIE

# Just ensuring to take a backup of the Makefile for fivextra to build, since autogen.sh removes it.
cp fivextra/Makefile Makefile-fivextra.bak

sh -x autogen.sh

CFLAGS="`echo $RPM_OPT_FLAGS $ARCH_OPT_FLAGS $PIE -D_FILE_OFFSET_BITS=64`"
%configure \
    CFLAGS="$CFLAGS" \
    CPPFLAGS="$DEFINES" \
    LDFLAGS="-pie" \
    --enable-mountconfig \
    --enable-ipv6 \
	--with-statdpath=/var/lib/nfs/statd \
	--enable-libmount-mount

make %{?_smp_mflags} all

pushd fivextra
mv ../Makefile-fivextra.bak Makefile
make all
popd

%install
rm -rf $RPM_BUILD_ROOT/*

mkdir -p $RPM_BUILD_ROOT%/sbin
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_unitdir}/nfs.target.wants
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/%{name}/scripts
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/request-key.d
mkdir -p $RPM_BUILD_ROOT/lib/modprobe.d/
make DESTDIR=$RPM_BUILD_ROOT install
install -s -m 755 tools/rpcdebug/rpcdebug $RPM_BUILD_ROOT%{_sbindir}
install -m 644 utils/mount/nfsmount.conf  $RPM_BUILD_ROOT%{_sysconfdir}
install -m 644 %{SOURCE9} $RPM_BUILD_ROOT%{_sysconfdir}/request-key.d
install -m 644 %{SOURCE10} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/nfs

for service in %{nfs_services} ; do
	install -m 644 $service $RPM_BUILD_ROOT%{_unitdir}
done

for service in %{nfs_automounts} ; do
	install -m 644 $service $RPM_BUILD_ROOT%{_unitdir}
done
for config in %{nfs_configs} ; do
	install -m 755 $config $RPM_BUILD_ROOT%{_libexecdir}/%{name}/scripts
done

# Steps to package the nfs-utils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

cd $RPM_BUILD_ROOT%{_unitdir}
ln -s nfs-idmap.service rpcidmapd.service
ln -s nfs-lock.service nfslock.service
ln -s nfs-secure-server.service rpcsvcgssd.service
ln -s nfs-secure.service rpcgssd.service
ln -s nfs-server.service nfs.service

mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/nfs/rpc_pipefs

touch $RPM_BUILD_ROOT%{_sharedstatedir}/nfs/rmtab
mv $RPM_BUILD_ROOT%{_sbindir}/rpc.statd $RPM_BUILD_ROOT/sbin

mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/nfs/statd/sm
mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/nfs/statd/sm.bak
mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/nfs/v4recovery
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/exports.d

%clean
rm -rf $RPM_BUILD_ROOT/*

%pre

# move files so the running service will have this applied as well
for x in gssd svcgssd idmapd ; do
    if [ -f /var/lock/subsys/rpc.$x ]; then
		mv /var/lock/subsys/rpc.$x /var/lock/subsys/rpc$x
    fi
done

/usr/sbin/useradd -l -c "RPC Service User" -r \
		-s /sbin/nologin -u 29 -d /var/lib/nfs rpcuser 2>/dev/null || :
/usr/sbin/groupadd -g 29 rpcuser 2>/dev/null || :

# Using the 16-bit value of -2 for the nfsnobody uid and gid
%define nfsnobody_uid	65534

# Create nfsnobody gid as long as it does not already exist
cat /etc/group | cut -d':' -f 1 | grep --quiet nfsnobody 2>/dev/null
if [ "$?" -eq 1 ]; then
    /usr/sbin/groupadd -g %{nfsnobody_uid} nfsnobody 2>/dev/null || :
else
    /usr/sbin/groupmod -g %{nfsnobody_uid} nfsnobody 2>/dev/null || :
fi

# Create nfsnobody uid as long as it does not already exist.
cat /etc/passwd | cut -d':' -f 1 | grep --quiet nfsnobody 2>/dev/null
if [ "$?" -eq 1 ]; then
    /usr/sbin/useradd -l -c "Anonymous NFS User" -r -g %{nfsnobody_uid} \
		-s /sbin/nologin -u %{nfsnobody_uid} -d /var/lib/nfs nfsnobody 2>/dev/null || :
else

   /usr/sbin/usermod -u %{nfsnobody_uid} -g %{nfsnobody_uid} nfsnobody 2>/dev/null || :
fi

%post
if [ $1 -eq 1 ]; then
	# Package install,
	/bin/systemctl enable nfs.target >/dev/null 2>&1 || :
	/bin/systemctl enable nfs-lock.service >/dev/null 2>&1 || : 
	/bin/systemctl start nfs-lock.service >/dev/null 2>&1 || :
else
	# Package upgrade
	if /bin/systemctl --quiet is-enabled nfs.target ; then
		/bin/systemctl reenable nfs.target >/dev/null 2>&1 || :
	fi
	if /bin/systemctl --quiet is-enabled nfs-lock.service ; then
		/bin/systemctl reenable nfs-lock.service >/dev/null 2>&1 || :
	fi
fi
# Make sure statd used the correct uid/gid.
chown -R rpcuser:rpcuser /var/lib/nfs/statd

%preun
if [ $1 -eq 0 ]; then
	# Package removal, not upgrade
	for service in %(sed 's!\S*/!!g' <<< '%{nfs_start_services}') ; do
		%systemd_preun $service
	done
    /usr/sbin/userdel rpcuser 2>/dev/null || :
    /usr/sbin/groupdel rpcuser 2>/dev/null || :
    /usr/sbin/userdel nfsnobody 2>/dev/null || :
    /usr/sbin/groupdel nfsnobody 2>/dev/null || :
    rm -rf /var/lib/nfs/statd
    rm -rf /var/lib/nfs/v4recovery
fi

%postun
if [ $1 -ge 1 ]; then
	# Package upgrade, not uninstall
	for service in %(sed 's!\S*/!!g' <<< '%{nfs_start_services}') ; do
		/bin/systemctl try-restart $service >/dev/null 2>&1 || :
	done
fi
/bin/systemctl --system daemon-reload >/dev/null 2>&1 || :

%triggerun -- nfs-utils < 1:1.2.4-2
/bin/systemctl enable nfs-lock.service >/dev/null 2>&1 || :
if /sbin/chkconfig --level 3 nfs ; then
	/bin/systemctl enable nfs-server.service >/dev/null 2>&1 || :
fi
if /sbin/chkconfig --level 3 rpcgssd ; then
	/bin/systemctl enable nfs-secure.service >/dev/null 2>&1 || :
fi
if /sbin/chkconfig --level 3 rpcsvcgssd ; then
	/bin/systemctl enable nfs-secure-server.service >/dev/null 2>&1 || :
fi

%files
%defattr(-,root,root,-)
%config(noreplace) /etc/sysconfig/nfs
%config(noreplace) /etc/nfsmount.conf
%dir %{_sysconfdir}/exports.d
%dir %{_sharedstatedir}/nfs/v4recovery
%dir %{_sharedstatedir}/nfs/rpc_pipefs
%dir %{_sharedstatedir}/nfs
%dir %{_libexecdir}/%{name}/scripts
%dir %{_libexecdir}/%{name}
%dir %attr(700,rpcuser,rpcuser) %{_sharedstatedir}/nfs/statd
%dir %attr(700,rpcuser,rpcuser) %{_sharedstatedir}/nfs/statd/sm
%dir %attr(700,rpcuser,rpcuser) %{_sharedstatedir}/nfs/statd/sm.bak
%config(noreplace) %attr(644,rpcuser,rpcuser) %{_sharedstatedir}/nfs/state
%config(noreplace) %{_sharedstatedir}/nfs/xtab
%config(noreplace) %{_sharedstatedir}/nfs/etab
%config(noreplace) %{_sharedstatedir}/nfs/rmtab
%config(noreplace) %{_sysconfdir}/request-key.d/id_resolver.conf
%doc linux-nfs/ChangeLog linux-nfs/KNOWNBUGS linux-nfs/NEW linux-nfs/README
%doc linux-nfs/THANKS linux-nfs/TODO
/sbin/rpc.statd
/sbin/osd_login
%{_sbindir}/exportfs
%{_sbindir}/nfsstat
%{_sbindir}/rpcdebug
%{_sbindir}/rpc.mountd
%{_sbindir}/rpc.nfsd
%{_sbindir}/showmount
%{_sbindir}/rpc.idmapd
%{_sbindir}/rpc.gssd
%{_sbindir}/rpc.svcgssd
%{_sbindir}/gss_clnt_send_err
%{_sbindir}/gss_destroy_creds
%{_sbindir}/sm-notify
%{_sbindir}/start-statd
%{_sbindir}/mountstats
%{_sbindir}/nfsiostat
%{_sbindir}/nfsidmap
%{_sbindir}/blkmapd
%{_sbindir}/nfsdcltrack
%{_mandir}/*/*
%{_unitdir}/*
%{_libexecdir}/%{name}/scripts/*

%attr(4755,root,root)	/sbin/mount.nfs
/sbin/mount.nfs4
/sbin/umount.nfs
/sbin/umount.nfs4

%files fivextra
%{prefix}

%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
