Summary: Library providing the Gnome XSLT engine
Name: libxslt
Version: 1.1.28
%define base_release .2
Release: 3%{?dist}%{?extra_release}%{?base_release}
License: MIT
Group: Development/Libraries
Source: ftp://xmlsoft.org/XSLT/libxslt-%{version}.tar.gz
Source999: fivextra.tar.bz2
URL: http://xmlsoft.org/XSLT/
BuildRequires: libxml2-devel >= 2.6.27
%if ! 0%{?cross_build}
BuildRequires: python2-devel
BuildRequires: libxml2-python
%endif
BuildRequires: libgcrypt-devel
BuildRequires: automake autoconf

# Fedora specific patches
Patch0: multilib.patch
Patch1: libxslt-1.1.26-utf8-docs.patch

%description
This C library allows to transform XML files into other XML files
(or HTML, text, ...) using the standard XSLT stylesheet transformation
mechanism. To use it you need to have a version of libxml2 >= 2.6.27
installed. The xsltproc command is a command line interface to the XSLT engine

%package devel
Summary: Development files for %{name}
Group: Development/Libraries
Requires: libxslt = %{version}-%{release}
Requires: libgcrypt-devel


%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%if ! 0%{?cross_build}
%package python
Summary: Python bindings for the libxslt library
Group: Development/Libraries
Requires: libxslt = %{version}-%{release}
Requires: libxml2-python

%description python
The libxslt-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libxslt library to apply XSLT transformations.

This library allows to parse sytlesheets, uses the libxml2-python
to load and save XML and HTML files. Direct access to XPath and
the XSLT transformation context are possible to extend the XSLT language
with XPath functions written in Python.
%endif

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra

%description fivextra
This package contains the testcases built from the package for %{name} 

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1
%patch1 -p1 -b .utf8
# Now fix up the timestamps of patched docs files
# ChangeLog needs to be retouched before gzip as well
# since timestamp affects output
#touch -r ChangeLog.utf8 ChangeLog
gzip -9 ChangeLog
#touch -r ChangeLog.utf8 ChangeLog.gz
#touch -r NEWS.utf8 NEWS

chmod 644 python/tests/*

# debranding redhat
[ -e doc/redhat.gif ] &&  rm doc/redhat.gif
for i in doc/* doc/html/* doc/EXSLT/* doc/EXSLT/html/* ; do
 if [ ! -d $i ]; then
        sed 's,redhat.gif,smallfootonly.gif,g' \
                $i >$i.tmp && \
        cat $i.tmp >$i && \
        rm -f $i.tmp

        sed 's,Red Hat Logo,,g' \
                $i >$i.tmp && \
        cat $i.tmp >$i && \
        rm -f $i.tmp

        sed 's,http://www.redhat.com,,g' \
                $i >$i.tmp && \
        cat $i.tmp >$i && \
        rm -f $i.tmp
 fi
done

%build
%configure --disable-static
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

# multiarch crazyness on timestamp differences
touch -m --reference=$RPM_BUILD_ROOT/%{_includedir}/libxslt/xslt.h $RPM_BUILD_ROOT/%{_bindir}/xslt-config

rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/%{name}-%{version}

# Steps to package the libxslt tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{fivdir}/../bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make tests

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root,-)
%doc AUTHORS ChangeLog.gz NEWS README Copyright FEATURES
%doc %{_mandir}/man1/xsltproc.1*
%{_libdir}/lib*.so.*
%{_libdir}/libxslt-plugins
%{_bindir}/xsltproc

%files devel
%defattr(-, root, root,-)
%doc doc/libxslt-api.xml
%doc doc/libxslt-refs.xml
%doc doc/EXSLT/libexslt-api.xml
%doc doc/EXSLT/libexslt-refs.xml
%doc %{_mandir}/man3/libxslt.3*
%doc %{_mandir}/man3/libexslt.3*
%doc doc/*.html doc/html doc/*.gif doc/*.png
%doc doc/images
%doc doc/tutorial
%doc doc/tutorial2
%doc doc/EXSLT
%{_libdir}/lib*.so
%{_libdir}/*.sh
%{_datadir}/aclocal/libxslt.m4
%{_includedir}/*
%{_bindir}/xslt-config
%{_libdir}/pkgconfig/libxslt.pc
%{_libdir}/pkgconfig/libexslt.pc

%if ! 0%{?cross_build}
%files python
%defattr(-, root, root,-)
%{python_sitearch}/libxslt.py*
%{python_sitearch}/libxsltmod*
%doc python/libxsltclass.txt
%doc python/tests/*.py
%doc python/tests/*.xml
%doc python/tests/*.xsl
%endif

%files fivextra
/opt/fiv/ltp/

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
