Name:           irqbalance
Version:        1.0.7
%define base_release .3
Release:        3%{?dist}%{?base_release}
# MCP: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Epoch:          2
Summary:        IRQ balancing daemon

Group:          System Environment/Base
License:        GPLv2
Url:            https://github.com/Irqbalance/irqbalance
Source0:        https://github.com/Irqbalance/irqbalance/archive/v%{version}.tar.gz
Source1:        irqbalance.sysconfig
Source999:     fivextra.tar.bz2

BuildRequires:  autoconf automake libtool libcap-ng
BuildRequires:  glib2-devel pkgconfig libcap-ng-devel
BuildRequires:  systemd
%ifnarch %{arm}
BuildRequires:  numactl-devel
BuildRequires:  systemd-units
Requires: numactl-libs
%endif
Requires(post): systemd-units
Requires(postun):systemd-units
Requires(preun):systemd-units
#Requires(triggerun):systemd-units

%define _hardened_build 1

ExclusiveArch: %{ix86} x86_64 ia64 ppc ppc64 %{arm}

Patch1: irqbalance-1.0.4-env-file-path.patch
#Patch2: irqbalance-1.0.6-man_usage_fix.patch
#Patch3: irqbalance-1.0.6-cpuhotplug-sigsegv.patch
#Patch4: irqbalance-1.0.6-man_IRQBALANCE_BANNED_CPUS.patch

%description
irqbalance is a daemon that evenly distributes IRQ load across
multiple CPUs for enhanced performance.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch1 -p1
#%patch2 -p1
#%patch3 -p1
#%patch4 -p1

%build
./autogen.sh
%{configure}
CFLAGS="%{optflags}" make %{?_smp_mflags}

%install
install -D -p -m 0755 %{name} %{buildroot}%{_sbindir}/%{name}
install -D -p -m 0644 ./misc/irqbalance.service %{buildroot}%{_unitdir}/irqbalance.service
install -D -p -m 0644 %{SOURCE1} %{buildroot}%{_sysconfdir}/sysconfig/%{name}

install -d %{buildroot}%{_mandir}/man1/
install -p -m 0644 ./irqbalance.1 %{buildroot}%{_mandir}/man1/

# Steps to package the irqbalance tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
        install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
        install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# create an /etc/sysconfig/irqbalance file
echo "IRQBALANCE_ARGS=\"--hintpolicy=ignore\"" > $RPM_BUILD_ROOT/etc/sysconfig/irqbalance

%files
%defattr(-,root,root)
%doc COPYING AUTHORS
%{_sbindir}/irqbalance
%{_unitdir}/irqbalance.service
%{_mandir}/man1/*
%config(noreplace) %{_sysconfdir}/sysconfig/irqbalance

%post
%systemd_post irqbalance.service

%preun
%systemd_preun irqbalance.service

%postun
%systemd_postun_with_restart irqbalance.service

%triggerun -- irqbalance < 2:0.56-3
if /sbin/chkconfig --level 3 irqbalance ; then
    /bin/systemctl enable irqbalance.service >/dev/null 2>&1 || :
fi
/sbin/chkconfig --del irqbalance >/dev/null 2>&1 || :

%files fivextra
%{prefix}


%changelog
* Tue Apr 01 2014 baseuser@ibm.com
- Base-8.x spec file
