%if ! (0%{?fedora} >= 12 || 0%{?rhel} > 5)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%endif

# if 0%{?fedora}
# global with_python3 1
# endif
# Base disables python3
%global with_python3 0


Name:           python-paste-deploy
Version:        1.5.0
%define base_release .2
Release:        10%{?dist}%{?base_release}
Summary:        Load, configure, and compose WSGI applications and servers
Group:          System Environment/Libraries
License:        MIT
URL:            http://pythonpaste.org/deploy
Source0:        http://cheeseshop.python.org/packages/source/P/PasteDeploy/PasteDeploy-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

# 1.5.0+ dropped Python 2.4 support
BuildRequires:  python2-devel > 2.4
BuildRequires:  python-setuptools
Requires:       python-paste
Requires:       python-setuptools

%description
This tool provides code to load WSGI applications and servers from
URIs; these URIs can refer to Python Eggs for INI-style configuration
files.  PasteScript provides commands to serve applications based on
this configuration file.

%if 0%{?with_python3}
%package -n python3-paste-deploy
Summary:        Load, configure, and compose WSGI applications and servers
Group:          System Environment/Libraries

BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
# Paste has not been ported to python3 (nor will it) and it only
# adds "extra" functionality to python3-paste-deploy
#Requires:       python3-paste
Requires:       python3-setuptools

%description -n python3-paste-deploy
This tool provides code to load WSGI applications and servers from
URIs; these URIs can refer to Python Eggs for INI-style configuration
files.  PasteScript provides commands to serve applications based on
this configuration file.

%endif


%prep
%setup -q -n PasteDeploy-%{version}

# Remove bundled egg-info if it exists
rm -rf *.egg-info

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif


%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root=%{buildroot}
rm -rf %{buildroot}%{python_sitelib}/test

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root=%{buildroot}
rm -rf %{buildroot}%{python3_sitelib}/test
popd
%endif

%clean
rm -rf %{buildroot}


%files
%defattr(0644,root,root,0755)
%doc docs/*
%{python_sitelib}/*

%if 0%{?with_python3}
%files -n python3-paste-deploy
%doc docs/*
%{python3_sitelib}/*
%endif



%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
