%define setools_maj_ver 3.3
%define setools_min_ver 7

Name: setools
Version: %{setools_maj_ver}.%{setools_min_ver}
%define base_release .2
Release: 38%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2
URL: http://oss.tresys.com/projects/setools
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Source: http://oss.tresys.com/projects/setools/chrome/site/dists/setools-%{version}/setools-%{version}.tar.bz2
Source1: setools.pam
Source2: apol.desktop
Source3: seaudit.desktop
Patch2: 0002-setools-should-exit-with-an-error-status-if-it-gets-.patch
Patch3: 0003-Since-we-do-not-ship-neverallow-rules-all-always-fai.patch
Patch4: 0004-Fix-man-pages-and-getoptions.patch
Patch5: 0005-Fix-sepol-calls-to-work-with-latest-libsepol.patch
Patch6: 0006-Changes-to-support-named-file_trans-rules.patch
Patch7: 0007-Remove-unused-variables.patch
Patch8: 0008-Fix-output-to-match-policy-lines.patch
Patch9: 0009-Fix-swig-coding-style-for-structures.patch
Patch10: 0010-selinux_current_policy_path.patch
Patch11: 0011-setools-noship.patch
Patch12: 0012-seaudit.patch
Patch13: 0013-swig.patch
Patch14: 0014-boolsub.patch
Patch15: 0015-aliases.patch

Summary: Policy analysis tools for SELinux
Group: System Environment/Base
Requires: setools-libs = %{version}-%{release} setools-libs-tcl = %{version}-%{release} setools-gui = %{version}-%{release} setools-console = %{version}-%{release}

# external requirements
%define autoconf_ver 2.59
%define bwidget_ver 1.8
%define gtk_ver 2.8
%define sepol_ver 2.1.8-5
%define selinux_ver 2.1.12-10
%define sqlite_ver 3.2.0
%define swig_ver 2.0.7-3
%define tcltk_ver 8.4.9

%description
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This meta-package depends upon the main packages necessary to run
SETools.

%package libs
License: LGPLv2
Summary: Policy analysis support libraries for SELinux
Group: System Environment/Libraries
Requires: libselinux >= %{selinux_ver} libsepol >= %{sepol_ver} sqlite >= %{sqlite_ver}
Obsoletes: setools-libs-java
Obsoletes: setools-libs-python < 3.3.7-36
BuildRequires: flex  bison  pkgconfig bzip2-devel
BuildRequires: glibc-devel libstdc++-devel gcc gcc-c++
BuildRequires: libselinux-devel >= %{selinux_ver} libsepol-devel >= %{sepol_ver}
BuildRequires: libsepol-static >= %{sepol_ver}
BuildRequires: sqlite-devel >= %{sqlite_ver} libxml2-devel
BuildRequires: tcl-devel >= %{tcltk_ver}
BuildRequires: autoconf >= %{autoconf_ver} automake

%description libs
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This package includes the following run-time libraries:

  libapol       policy analysis library
  libpoldiff    semantic policy difference library
  libqpol       library that abstracts policy internals
  libseaudit    parse and filter SELinux audit messages in log files
  libsefs       SELinux file contexts library

%package libs-tcl
License: LGPLv2
Summary: Tcl bindings for SELinux policy analysis
Group: Development/Languages
Requires: setools-libs = %{version}-%{release} tcl >= %{tcltk_ver}
BuildRequires: tcl-devel >= %{tcltk_ver} swig >= %{swig_ver}

%description libs-tcl
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This package includes Tcl bindings for the following libraries:

  libapol       policy analysis library
  libpoldiff    semantic policy difference library
  libqpol       library that abstracts policy internals
  libseaudit    parse and filter SELinux audit messages in log files
  libsefs       SELinux file contexts library

%package devel
License: LGPLv2
Summary: Policy analysis development files for SELinux
Group: Development/Libraries
Requires: libselinux-devel >= %{selinux_ver} libsepol-devel >= %{sepol_ver} setools-libs = %{version}-%{release}
BuildRequires: sqlite-devel >= %{sqlite_ver} libxml2-devel

%description devel
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This package includes header files and archives for the following
libraries:

  libapol       policy analysis library
  libpoldiff    semantic policy difference library
  libqpol       library that abstracts policy internals
  libseaudit    parse and filter SELinux audit messages in log files
  libsefs       SELinux file contexts library

%package console
Summary: Policy analysis command-line tools for SELinux
Group: System Environment/Base
License: GPLv2
Requires: setools-libs = %{version}-%{release}
Requires: libselinux >= %{selinux_ver}

%description console
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This package includes the following console tools:

  secmds          command line tools: seinfo, sesearch
  sediff          semantic policy difference tool

%package gui
Summary: Policy analysis graphical tools for SELinux
Group: System Environment/Base
Requires: tcl >= %{tcltk_ver} tk >= %{tcltk_ver} bwidget >= %{bwidget_ver}
Requires: setools-libs = %{version}-%{release} setools-libs-tcl = %{version}-%{release}
Requires: glib2 gtk2 >= %{gtk_ver} usermode
BuildRequires: gtk2-devel >= %{gtk_ver} libglade2-devel libxml2-devel tk-devel >= %{tcltk_ver}
BuildRequires: desktop-file-utils

%description gui
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This package includes the following graphical tools:

  apol          policy analysis tool
  seaudit       audit log analysis tool

%define setoolsdir %{_datadir}/setools-%{setools_maj_ver}
%define tcllibdir %{_libdir}/setools

%prep
%setup -q
%patch2 -p 1 -b .exitstatus
%patch3 -p 1 -b .neverallow
%patch4 -p 1 -b .manpage
%patch5 -p 1 -b .libsepol
%patch6 -p 1 -b .filenametrans
%patch7 -p 1 -b .unused 
%patch8 -p 1 -b .fixoutput
%patch9 -p 1 -b .fixswig
%patch10 -p 1 -b .current
%patch11 -p 1 -b .noship
%patch12 -p 1 -b .seaudit
%patch13 -p 1 -b .swig
%patch14 -p 2 -b .boolsub
%patch15 -p 1 -b .aliases
%ifarch sparc sparcv9 sparc64 s390 s390x
    for file in `find . -name Makefile.am`; do
        sed -i -e 's:-fpic:-fPIC:' $file;
    done
%endif
# Fixup expected version of SWIG:
sed -i -e "s|AC_PROG_SWIG(1.3.28)|AC_PROG_SWIG(2.0.0)|g" configure.ac
# and rebuild the autotooled files:
aclocal
autoreconf -if

%build
automake
%configure --libdir=%{_libdir} --disable-bwidget-check --disable-selinux-check \
    --enable-swig-tcl
# work around issue with gcc 4.3 + gnu99 + swig-generated code:
make %{?_smp_mflags}

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} INSTALL="install -p" install
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/applications
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/pixmaps
install -d -m 755 ${RPM_BUILD_ROOT}%{_sysconfdir}/pam.d
install -p -m 644 %{SOURCE1} ${RPM_BUILD_ROOT}%{_sysconfdir}/pam.d/seaudit
install -d -m 755 ${RPM_BUILD_ROOT}%{_sysconfdir}/security/console.apps
install -p -m 644 packages/rpm/seaudit.console ${RPM_BUILD_ROOT}%{_sysconfdir}/security/console.apps/seaudit
install -d -m 755 ${RPM_BUILD_ROOT}%{_datadir}/applications
install -p -m 644 apol/apol.png ${RPM_BUILD_ROOT}%{_datadir}/pixmaps/apol.png
install -p -m 644 seaudit/seaudit.png ${RPM_BUILD_ROOT}%{_datadir}/pixmaps/seaudit.png
desktop-file-install --dir ${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE2}
ln -sf consolehelper ${RPM_BUILD_ROOT}/%{_bindir}/seaudit
# remove static libs
rm -f ${RPM_BUILD_ROOT}/%{_libdir}/*.a
# ensure permissions are correct
chmod 0755 ${RPM_BUILD_ROOT}/%{_libdir}/*.so.*
chmod 0755 ${RPM_BUILD_ROOT}/%{_libdir}/%{name}/*/*.so.*
chmod 0644 ${RPM_BUILD_ROOT}/%{tcllibdir}/*/pkgIndex.tcl

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root,-)

%files libs
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING COPYING.GPL COPYING.LGPL KNOWN-BUGS NEWS README
%{_libdir}/libqpol.so.*
%{_libdir}/libapol.so.*
%{_libdir}/libpoldiff.so.*
%{_libdir}/libsefs.so.*
%{_libdir}/libseaudit.so.*
%dir %{setoolsdir}

%files libs-tcl
%defattr(-,root,root,-)
%dir %{tcllibdir}
%{tcllibdir}/qpol/
%{tcllibdir}/apol/
%{tcllibdir}/poldiff/
%{tcllibdir}/seaudit/
%{tcllibdir}/sefs/

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_includedir}/qpol/
%{_includedir}/apol/
%{_includedir}/poldiff/
%{_includedir}/seaudit/
%{_includedir}/sefs/

%files console
%defattr(-,root,root,-)
%{_bindir}/seinfo
%{_bindir}/sesearch
%{_bindir}/sediff
%{_mandir}/man1/sediff.1.gz
%{_mandir}/man1/seinfo.1.gz
%{_mandir}/man1/sesearch.1.gz

%files gui
%defattr(-,root,root,-)
%{_bindir}/seaudit
%{_bindir}/apol
%{tcllibdir}/apol_tcl/
%{setoolsdir}/apol_help.txt
%{setoolsdir}/domaintrans_help.txt
%{setoolsdir}/file_relabel_help.txt
%{setoolsdir}/infoflow_help.txt
%{setoolsdir}/types_relation_help.txt
%{setoolsdir}/apol_perm_mapping_*
%{setoolsdir}/seaudit_help.txt
%{setoolsdir}/*.glade
%{setoolsdir}/*.png
%{setoolsdir}/apol.gif
%{setoolsdir}/dot_seaudit
%{_mandir}/man1/apol.1.gz
%{_mandir}/man8/seaudit.8.gz
%{_sbindir}/seaudit
%config(noreplace) %{_sysconfdir}/pam.d/seaudit
%config(noreplace) %{_sysconfdir}/security/console.apps/seaudit
%{_datadir}/applications/*
%attr(0644,root,root) %{_datadir}/pixmaps/*.png

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%post libs-tcl -p /sbin/ldconfig

%postun libs-tcl -p /sbin/ldconfig

%changelog
* Sun May 05 2013 baseuser@ibm.com
- Base-8.x spec file
