Summary: A network traffic monitoring tool
Name: tcpdump
Epoch: 14
Version: 4.4.0
%define base_release .3
Release: 1%{?dist}%{?base_release}
License: BSD with advertising
URL: http://www.tcpdump.org
Group: Applications/Internet
Requires(pre): shadow-utils
BuildRequires: openssl-devel libpcap-devel
BuildRequires: automake sharutils

Source0: http://www.tcpdump.org/release/tcpdump-%{version}.tar.gz
Source1: ftp://ftp.ee.lbl.gov/tcpslice-1.2a3.tar.gz
Source999: fivextra.tar.bz2

Patch1: tcpdump-4.0.0-portnumbers.patch
Patch2: tcpdump-4.0.0-icmp6msec.patch
Patch3: tcpdump-3.9.8-gethostby.patch
Patch4: tcpdump-4.4.0-eperm.patch
Patch5: tcpslice-1.2a3-time.patch
Patch6: tcpslice-CVS.20010207-bpf.patch
Patch7: tcpslice-1.2a3-dateformat.patch

%define tcpslice_dir tcpslice-1.2a3

%description
Tcpdump is a command-line tool for monitoring network traffic.
Tcpdump can capture and display the packet headers on a particular
network interface or on all interfaces.  Tcpdump can display all of
the packet headers, or just the ones that match particular criteria.

Install tcpdump if you need a program to monitor network traffic.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 1 -a 999

%patch1 -p1 -b .portnumbers
%patch2 -p1 -b .icmp6msec
%patch3 -p1 -b .gethostby
%patch4 -p1 -b .eperm

pushd %{tcpslice_dir}
%patch5 -p1 -b .time
%patch6 -p1 -b .bpf
%patch7 -p1 -b .dateformat
popd

find . -name '*.c' -o -name '*.h' | xargs chmod 644

%build
%{?cross_build:export ac_cv_linux_vers=${ac_cv_linux_vers=2}}
export CFLAGS="$RPM_OPT_FLAGS $(getconf LFS_CFLAGS) -fno-strict-aliasing"

pushd %{tcpslice_dir}
# update config.{guess,sub}
automake -a -f 2> /dev/null || :
%configure
make %{?_smp_mflags}
popd

%configure %{?cross_build:--without-crypto}%{!?cross_build:--with-crypto} \
       --with-user=tcpdump --without-smi
make %{?_smp_mflags}

pushd fivextra
make all
popd

%check
#make check

%install
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}

pushd %{tcpslice_dir}
install -m755 tcpslice ${RPM_BUILD_ROOT}%{_sbindir}
install -m644 tcpslice.1 ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpslice.8
popd

install -m755 tcpdump ${RPM_BUILD_ROOT}%{_sbindir}
install -m644 tcpdump.1 ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpdump.8

# fix section numbers
sed -i 's/\(\.TH[a-zA-Z ]*\)[1-9]\(.*\)/\18\2/' \
	${RPM_BUILD_ROOT}%{_mandir}/man8/*

# Steps to package the tcpdump tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%pre
/usr/sbin/groupadd -g 72 tcpdump 2> /dev/null
/usr/sbin/useradd -u 72 -g 72 -s /sbin/nologin -M -r \
	-d / tcpdump 2> /dev/null
exit 0

%files
%defattr(-,root,root)
%doc LICENSE README CHANGES CREDITS
%{_sbindir}/tcpdump
%{_sbindir}/tcpslice
%{_mandir}/man8/tcpslice.8*
%{_mandir}/man8/tcpdump.8*

%files fivextra
%{prefix}

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
