Summary: A library of functions for manipulating PNG image format files
Name: libpng
Epoch: 2
Version: 1.5.13
%define base_release .3
Release: 2%{?dist}%{?base_release}
License: zlib
Group: System Environment/Libraries
URL: http://www.libpng.org/pub/png/

# Note: non-current tarballs get moved to the history/ subdirectory,
# so look there if you fail to retrieve the version you want
Source0: ftp://ftp.simplesystems.org/pub/png/src/libpng-%{version}.tar.bz2

Source1: pngusr.dfa

Source999: fivextra.tar.bz2

Patch0: libpng-multilib.patch

BuildRequires: zlib-devel, pkgconfig

%description
The libpng package contains a library of functions for creating and
manipulating PNG (Portable Network Graphics) image format files.  PNG
is a bit-mapped graphics format similar to the GIF format.  PNG was
created to replace the GIF format, since GIF uses a patented data
compression algorithm.

Libpng should be installed if you need to manipulate PNG format image
files.

%package devel
Summary: Development tools for programs to manipulate PNG image format files
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{epoch}:%{version}-%{release}
Requires: zlib-devel%{?_isa} pkgconfig%{?_isa}

%description devel
The libpng-devel package contains header files and documentation necessary
for developing programs using the PNG (Portable Network Graphics) library.

If you want to develop programs which will manipulate PNG image format
files, you should install libpng-devel.  You'll also need to install
the libpng package.

%package static
Summary: Static PNG image format file library
Group: Development/Libraries
Requires: %{name}-devel%{?_isa} = %{epoch}:%{version}-%{release}

%description static
The libpng-static package contains the statically linkable version of libpng.
Linking to static libraries is discouraged for most applications, but it is
necessary for some boot packages.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999

# Provide pngusr.dfa for build.
cp -p %{SOURCE1} .

%patch0 -p1

%build
%configure
make %{?_smp_mflags} DFA_XTRA=pngusr.dfa
make CFLAGS="$CFLAGS -I.." pngtest

%install
make DESTDIR=$RPM_BUILD_ROOT install

# We don't ship .la files.
rm -rf $RPM_BUILD_ROOT%{_libdir}/*.la

# Steps to package the libpng tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install .libs/pngtest pngtest.png $RPM_BUILD_ROOT/%{fivdir}/%{name}

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 1 \
-name '*.c' -o -name '*.h' -o -name '*.o' | xargs rm -rf

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc libpng-manual.txt example.c README TODO CHANGES LICENSE
%{_libdir}/libpng15.so.*
%{_mandir}/man5/*

%files devel
%{_bindir}/*
%{_includedir}/*
%{_libdir}/libpng*.so
%{_libdir}/pkgconfig/libpng*.pc
%{_mandir}/man3/*

%files static
%{_libdir}/libpng*.a

%files fivextra
%{prefix}

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
