%define fontname thai-scalable
%define fontconf 90-%{fontname}-synthetic

%define archivename fonts-tlwg

%define common_desc \
%{archivename} provides a collection of free scalable Thai fonts.

Name:      %{fontname}-fonts
Version:   0.5.0
%define base_release .1
Release:   6%{?dist}%{?base_release}
Summary:   Thai TrueType fonts
Group:     User Interface/X
License:   GPLv2+ and Bitstream Vera
URL:       http://linux.thai.net/projects/thaifonts-scalable
Source0:   http://linux.thai.net/pub/ThaiLinux/software/%{archivename}/%{archivename}-%{version}.tar.gz
Source1:   %{fontconf}-garuda.conf
Source2:   %{fontconf}-kinnari.conf
Source3:   %{fontconf}-umpush.conf
BuildArch: noarch
BuildRequires: fontforge >= 20071110
BuildRequires: fontpackages-devel

%description
%common_desc

Thai scalable fonts included here are:
- Kinnari, Garuda and Norasi from the National Font project
- DB Thai Text from DearBook
- TlwgMono, PseudoMono, Purisa by TLWG


%package common
Summary:   Common files of %{name}
Group:     User Interface/X
Requires:  fontpackages-filesystem

%description common
%common_desc

This package consists of files used by other %{name} packages.


%package -n %{fontname}-garuda-fonts
Summary:        Thai Garuda fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-garuda-fonts
%common_desc

This package provides the Garuda family of Thai fonts.

%_font_pkg -n garuda -f %{fontconf}-garuda.conf Garuda*.ttf


%package -n %{fontname}-kinnari-fonts
Summary:        Thai Kinnari fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-kinnari-fonts
%common_desc

This package provides the Kinnari family of Thai fonts.

%_font_pkg -n kinnari -f %{fontconf}-kinnari.conf Kinnari*.ttf


%package -n %{fontname}-loma-fonts
Summary:        Thai Loma fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-loma-fonts
%common_desc

This package provides the Loma family of Thai fonts.

%_font_pkg -n loma Loma*.ttf


%package -n %{fontname}-norasi-fonts
Summary:        Thai Norasi fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-norasi-fonts
%common_desc

This package provides the Norasi family of Thai fonts.

%_font_pkg -n norasi Norasi*.ttf


%package -n %{fontname}-purisa-fonts
Summary:        Thai Purisa fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-purisa-fonts
%common_desc

This package provides the Purisa family of Thai fonts.

%_font_pkg -n purisa Purisa*.ttf


%package -n %{fontname}-sawasdee-fonts
Summary:        Thai Sawasdee fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-sawasdee-fonts
%common_desc

This package provides the Sawasdee family of Thai fonts.

%_font_pkg -n sawasdee Sawasdee*.ttf


%package -n %{fontname}-tlwgmono-fonts
Summary:        Thai TlwgMono fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-tlwgmono-fonts
%common_desc

This package provides the TlwgMono family of Thai fonts.

%_font_pkg -n tlwgmono TlwgMono*.ttf


%package -n %{fontname}-tlwgtypewriter-fonts
Summary:        Thai TlwgTypewriter fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-tlwgtypewriter-fonts
%common_desc

This package provides the TlwgTypewriter family of Thai fonts.

%_font_pkg -n tlwgtypewriter TlwgTypewriter*.ttf


%package -n %{fontname}-tlwgtypist-fonts
Summary:        Thai TlwgTypist fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-tlwgtypist-fonts
%common_desc

This package provides the TlwgTypist family of Thai fonts.

%_font_pkg -n tlwgtypist TlwgTypist*.ttf


%package -n %{fontname}-tlwgtypo-fonts
Summary:        Thai TlwgTypo fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-tlwgtypo-fonts
%common_desc

This package provides the TlwgTypo family of Thai fonts.

%_font_pkg -n tlwgtypo TlwgTypo*.ttf


%package -n %{fontname}-umpush-fonts
Summary:        Thai Umpush fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-umpush-fonts
%common_desc

This package provides the Umpush family of Thai fonts.

%_font_pkg -n umpush -f %{fontconf}-umpush.conf Umpush*.ttf


%package -n %{fontname}-waree-fonts
Summary:        Thai Waree fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-waree-fonts
%common_desc

This package provides the Waree family of Thai fonts.

%_font_pkg -n waree Waree*.ttf


%prep
%setup -q -n %{archivename}-%{version}


%build
%configure --with-ttfdir=%{_fontdir} --enable-ttf
make


%install
install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

make install DESTDIR=%{buildroot} INSTALL="install -p"

# remove upstream font config
# fontconfig's 65-nonlatin.conf covers 65-ttf-thai-tlwg.conf
rm %{buildroot}%{_sysconfdir}/fonts/conf.avail/*-ttf-thai-tlwg*.conf

# split up 90-ttf-thai-tlwg-synthetic.conf
install -m 0644 -p %{SOURCE1} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-garuda.conf
install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-kinnari.conf
install -m 0644 -p %{SOURCE3} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-umpush.conf

for fconf in %{fontconf}-garuda.conf \
             %{fontconf}-kinnari.conf \
             %{fontconf}-umpush.conf ; do
  ln -s %{_fontconfig_templatedir}/$fconf \
        %{buildroot}%{_fontconfig_confdir}/$fconf
done


%files common
%doc AUTHORS README COPYING NEWS


%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
