Name: MAKEDEV
Version: 3.24
%define base_release .2
Release: 12%{?dist}%{?base_release}
Group: System Environment/Base
License: GPLv2
# This is a Red Hat maintained package which is specific to
# our distribution.  Thus the source is only available from
# within this srpm.
Source0: MAKEDEV-%{version}-1.tar.gz
# manpage courtesy of mandriva
Source1: makedev.d.5
Summary: A program used for creating device files in /dev
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libselinux-devel
URL: http://www.lanana.org/docs/device-list/
Requires(pre): shadow-utils, /usr/bin/getent
Requires: udev

%description
This package contains the MAKEDEV program, which makes it easier to create
and maintain the files in the /dev directory.  /dev directory files
correspond to a particular device supported by Linux (serial or printer
ports, scanners, sound cards, tape drives, CD-ROM drives, hard drives,
etc.) and interface with the drivers in the kernel.

You should install the MAKEDEV package because the MAKEDEV utility makes
it easy to manage the /dev directory device files.

%prep
%setup -q

%build
make CC=%{__cc} OPTFLAGS="$RPM_OPT_FLAGS" SELINUX=1

%install
make install DESTDIR=$RPM_BUILD_ROOT devdir=/dev makedevdir=/sbin
rm -f $RPM_BUILD_ROOT/dev/MAKEDEV
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man5
install -m 644 -p %{SOURCE1} $RPM_BUILD_ROOT/%{_mandir}/man5
mkdir -p $RPM_BUILD_ROOT/lib/udev/devices
ln -s /sbin/MAKEDEV $RPM_BUILD_ROOT/lib/udev/devices/MAKEDEV

%clean
rm -fr $RPM_BUILD_ROOT

%pre
# Add the floopy group and the vcsa user.
getent group floppy >/dev/null || groupadd -g 19 -r -f floppy
getent group vcsa >/dev/null || groupadd -g 69 -r -f vcsa
getent passwd vcsa >/dev/null || \
	useradd -r -g vcsa -d /dev -s /sbin/nologin -u 69 \
	-c "virtual console memory owner" vcsa 2>/dev/null
exit 0

%files
%defattr(-,root,root)
%doc COPYING devices-2.6+.txt
%{_mandir}/man8/*
%{_sbindir}/mksock
/sbin/MAKEDEV
/lib/udev/devices/MAKEDEV
%config(noreplace) %{_sysconfdir}/makedev.d
%{_mandir}/man5/makedev.d.5*

%changelog
* Tue Jul 16 2013 baseuser@ibm.com
- Base-8.x spec file
