%if 0%{?fedora}
# This is disabled until python3-pyparsing-2.0 or later is available.
# https://bugzilla.redhat.com/show_bug.cgi?id=950775
%global with_python3 0
%endif

%global modname cliff

Name:             python-cliff
Version:          1.4.4
%define base_release .2
Release:          1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:          Command Line Interface Formulation Framework

Group:            Development/Libraries
License:          ASL 2.0
URL:              http://pypi.python.org/pypi/cliff
Source0:          http://pypi.python.org/packages/source/c/cliff/cliff-%{version}.tar.gz
Patch0:           python-cliff-loosen-pyparsing-constraint.patch

BuildArch:        noarch

BuildRequires:    python2-devel
BuildRequires:    python-setuptools
BuildRequires:    python-prettytable
BuildRequires:    python-cmd2
Requires:         python-setuptools
Requires:         python-prettytable
Requires:         python-cmd2

%if %{?rhel}%{!?rhel:0} >= 6 || 0%{?fedora} > 19
BuildRequires:    python-argparse
Requires:         python-argparse
%endif


%if 0%{?with_python3}
BuildRequires:    python3-devel
BuildRequires:    python3-setuptools
BuildRequires:    python3-prettytable
BuildRequires:    python3-cmd2

# This is actually a dep of python3-cmd2, but we need a certain version.
BuildRequires:    python3-pyparsing>=2.0.0
%endif

%description
cliff is a framework for building command line programs. It uses setuptools
entry points to provide subcommands, output formatters, and other
extensions.

Documentation for cliff is hosted on readthedocs.org at
http://readthedocs.org/docs/cliff/en/latest/

%if 0%{?with_python3}
%package -n python3-cliff
Summary:        Command Line Interface Formulation Framework
Group:          Development/Libraries

Requires:         python3-setuptools
Requires:         python3-prettytable
Requires:         python3-cmd2

# This is actually a dep of python3-cmd2, but we need a certain version.
Requires:         python3-pyparsing>=2.0.0

%description -n python3-cliff
cliff is a framework for building command line programs. It uses setuptools
entry points to provide subcommands, output formatters, and other
extensions.

Documentation for cliff is hosted on readthedocs.org at
http://readthedocs.org/docs/cliff/en/latest/
%endif

%prep
%setup -q -n %{modname}-%{version}
%patch0 -p1 -b .pyparsing

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif



%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
popd
%endif

%{__python} setup.py install -O1 --skip-build --root=%{buildroot}

%check
%{__python} setup.py test

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test
popd
%endif


%files
%doc docs/
%{python_sitelib}/%{modname}
%{python_sitelib}/%{modname}-%{version}*

%if 0%{?with_python3}
%files -n python3-%{modname}
%doc docs/
%{python3_sitelib}/%{modname}
%{python3_sitelib}/%{modname}-%{version}-*
%endif


%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
