%define _bindir /bin

Summary: Pattern matching utilities
Name: grep
Version: 2.16
%define base_release .3
Release: 4%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Text
Source: ftp://ftp.gnu.org/pub/gnu/grep/grep-%{version}.tar.xz
Source1: colorgrep.sh
Source2: colorgrep.csh
Source3: GREP_COLORS
Source999: fivextra.tar.bz2
# upstream ticket 39444
Patch0: grep-2.16-man-fix-gs.patch
# upstream ticket 39445
Patch1: grep-2.16-help-align.patch
URL: http://www.gnu.org/software/grep/
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
BuildRequires: pcre-devel >= 3.9-10, texinfo, gettext
BuildRequires: autoconf automake
# https://fedorahosted.org/fpc/ticket/174
Provides: bundled(gnulib)

%description
The GNU versions of commonly used grep utilities. Grep searches through
textual input for lines which contain a match to a specified pattern and then
prints the matching lines. GNU's grep utilities include grep, egrep and fgrep.

GNU grep is needed by many scripts, so it shall be installed on every system.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
%patch0 -p1 -b .man-fix-gs
%patch1 -p1 -b .help-align

%build
%global BUILD_FLAGS $RPM_OPT_FLAGS

# Currently gcc on ppc uses double-double arithmetic for long double and it
# does not conform to the IEEE floating-point standard. Thus force
# long double to be double and conformant.
%ifarch ppc ppc64
%global BUILD_FLAGS %{BUILD_FLAGS} -mlong-double-64
%endif

%configure --without-included-regex CPPFLAGS="-I%{_includedir}/pcre" \
  CFLAGS="%{BUILD_FLAGS}"
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf ${RPM_BUILD_ROOT}
make %{?_smp_mflags} DESTDIR=$RPM_BUILD_ROOT install
gzip $RPM_BUILD_ROOT%{_infodir}/grep*
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/profile.d
install -pm 644 %{SOURCE1} %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/profile.d
install -pm 644 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}

# Steps to package the grep tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %name

%check
make check

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/install-info --quiet --info-dir=%{_infodir} %{_infodir}/grep.info.gz || :

%preun
if [ $1 = 0 ]; then
	/sbin/install-info --quiet --info-dir=%{_infodir} --delete %{_infodir}/grep.info.gz || :
fi

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc ABOUT-NLS AUTHORS THANKS TODO NEWS README ChangeLog COPYING

%{_bindir}/*
%config(noreplace) %{_sysconfdir}/profile.d/colorgrep.*sh
%config(noreplace) %{_sysconfdir}/GREP_COLORS
%{_infodir}/*.info*.gz
%{_mandir}/*/*

%files fivextra
%{prefix}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
