# F-17 and above have ruby-1.9.x, and place libs in a different location
# The checks also fail on older releases, due to an older mocha gem, it appears
%if 0%{?fedora} >= 17 || 0%{?base} >= 19
%global enable_check    0
%global facter_libdir   %(ruby -rrbconfig -e 'puts RbConfig::CONFIG["vendorlibdir"]')
%else
%global enable_check    0
%global facter_libdir   %(ruby -rrbconfig -e 'puts RbConfig::CONFIG["sitelibdir"]')
%endif

%global ruby_version    %(ruby -rrbconfig -e 'puts RbConfig::CONFIG["ruby_version"]')

# There is nothing useful in debuginfo, facter is only an arch package to
# allow arch-dependent requires.
%global debug_package %{nil}

Name:           facter
Version:        1.7.4
%define base_release .3
Release:        3%{?dist}%{?base_release}
# Base: exclude cross arches for this package because of the need for Ruby
ExcludeArch: %{cross_arches}
Summary:        Command and ruby library for gathering system information

Group:          System Environment/Base
License:        ASL 2.0
URL:            https://puppetlabs.com/%{name}
Source0:        https://downloads.puppetlabs.com/%{name}/%{name}-%{version}.tar.gz
Source1:        https://downloads.puppetlabs.com/%{name}/%{name}-%{version}.tar.gz.asc
# https://tickets.puppetlabs.com/browse/FACT-86
Patch0:         facter-1.7.4-dmidecode-drop-stderr.patch
Patch1:		facter-1.7.4-powerkvm.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  ruby >= 1.8.1
BuildRequires:  ruby-devel
%if %{enable_check}
BuildRequires:  net-tools
BuildRequires:  rubygem(mocha)
BuildRequires:  rubygem(rspec-core)
BuildRequires:  rubygem(rspec)
%endif

# dmidecode and pciutils are not available on all arches
%ifarch %ix86 x86_64 ia64
Requires:       dmidecode
Requires:       pciutils
Requires:       virt-what
%endif
Requires:       net-tools
# Work around the lack of ruby in the default mock buildroot
%if "%{ruby_version}"
%if 0%{?fedora} >= 19 || 0%{?base} >= 19
Requires:       ruby(release)
%else
Requires:       ruby(abi) = %{ruby_version}
%endif
%endif
Requires:       which

%description
Facter is a lightweight program that gathers basic node information about the
hardware and operating system. Facter is especially useful for retrieving
things like operating system names, hardware characteristics, IP addresses, MAC
addresses, and SSH keys.

Facter is extensible and allows gathering of node information that may be
custom or site specific. It is easy to extend by including your own custom
facts. Facter can also be used to create conditional expressions in Puppet that
key off the values returned by facts.

%prep
%setup -q
%patch0 -p1 -b .dmidecode-drop-stderr
%patch1 -p1

%build
# Nothing to build


%install
rm -rf %{buildroot}
ruby install.rb --destdir=%{buildroot} --quick --no-rdoc --sitelibdir=%{facter_libdir}

# Create directory for external facts
mkdir -p %{buildroot}/%{_sysconfdir}/%{name}/facts.d

%if ! (0%{?fedora} || 0%{?rhel} >= 7) || 0%{?base} >= 19
# Install man page, rubygem-rdoc is not available on older EL releases)
install -D -pv -m 644 man/man8/%{name}.8 %{buildroot}/%{_mandir}/man8/%{name}.8
%endif

%postun
# Work around issues where puppet fails to run after a facter update
# https://bugzilla.redhat.com/806370
# http://projects.puppetlabs.com/issues/12879
if [ "$1" -ge 1 ]; then
  /sbin/service puppet condrestart >/dev/null 2>&1 || :
fi


%clean
rm -rf %{buildroot}


%check
%if %{enable_check}
rspec spec
%endif


%files
%defattr(-,root,root,-)
%doc LICENSE README.md
%{_bindir}/%{name}
%{_sysconfdir}/%{name}
%{facter_libdir}/%{name}*
%{_mandir}/man8/%{name}*


%changelog
* Wed Oct 23 2013 baseuser@ibm.com
- Base-8.x spec file
