Name:           perl-HTTP-Daemon
Version:        6.01
%define base_release .2
Release:        5%{?dist}%{?base_release}
Summary:        Simple HTTP server class
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/HTTP-Daemon/
Source0:        http://www.cpan.org/authors/id/G/GA/GAAS/HTTP-Daemon-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl(Carp)
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(HTTP::Date) >= 6
BuildRequires:  perl(HTTP::Request) >= 6
BuildRequires:  perl(HTTP::Response) >= 6
BuildRequires:  perl(HTTP::Status) >= 6
BuildRequires:  perl(IO::Socket)
BuildRequires:  perl(LWP::MediaTypes) >= 6
BuildRequires:  perl(Sys::Hostname)
# Tests only:
BuildRequires:  perl(Config)
# Do not depend on perl(LWP::UserAgent), perl(LWP::RobotUA) to break
# circural dependency, then only t/chunked.t is executed.
BuildRequires:  perl(Test::More)
BuildRequires:  perl(Socket)
BuildRequires:  perl(IO::Socket::INET)
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl(HTTP::Date) >= 6
Requires:       perl(HTTP::Request) >= 6
Requires:       perl(HTTP::Response) >= 6
Requires:       perl(HTTP::Status) >= 6
Requires:       perl(LWP::MediaTypes) >= 6
Requires:       perl(Sys::Hostname)
Conflicts:      perl-libwww-perl < 6

# Remove underspecified dependencies
%filter_from_requires /^perl(HTTP::Date)\s*$/d;
%filter_from_requires /^perl(HTTP::Request)\s*$/d;
%filter_from_requires /^perl(HTTP::Response)\s*$/d;
%filter_from_requires /^perl(HTTP::Status)\s*$/d;
%filter_from_requires /^perl(LWP::MediaTypes)\s*$/d;
%filter_setup

%global __requires_exclude %{?__requires_exclude:%__requires_exclude|}perl\\(HTTP::(Date|Request|Response|Status)|LWP::MediaTypes\\)$

%description
Instances of the HTTP::Daemon class are HTTP/1.1 servers that listen on a
socket for incoming requests. The HTTP::Daemon is a subclass of
IO::Socket::INET, so you can perform socket operations directly on it too.

%prep
%setup -q -n HTTP-Daemon-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;
%{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendorlib}/*
%{_mandir}/man3/*

%changelog
* Fri Sep 20 2013 baseuser@ibm.com
- Base-8.x spec file
