%global compat_ver xz-4.999.9beta

Summary:	LZMA compression utilities
Name:		xz
Version:	5.1.2
%define base_release .4
Release:	4alpha%{?dist}%{?base_release}
License:	LGPLv2+
Group:		Applications/File
# official upstream release
Source0:	http://tukaani.org/%{name}/%{name}-%{version}alpha.tar.gz
# source created as "make dist" in checked out GIT tree
Source1:	%{compat_ver}.20100401git.tar.bz2
Source999: fivextra.tar.bz2
Patch81413: xz-5.1.2-4alpha-fiv-tests.patch
Patch95603: xz-5.1.2-4alpha-port-tests.patch
URL:		http://tukaani.org/%{name}/
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires:	%{name}-libs = %{version}-%{release}

%description
XZ Utils are an attempt to make LZMA compression easy to use on free (as in
freedom) operating systems. This is achieved by providing tools and libraries
which are similar to use than the equivalents of the most popular existing
compression algorithms.

LZMA is a general purpose compression algorithm designed by Igor Pavlov as
part of 7-Zip. It provides high compression ratio while keeping the
decompression speed fast.

%package 	libs
Summary:	Libraries for decoding LZMA compression
Group:		System Environment/Libraries
License:	LGPLv2+

%description 	libs
Libraries for decoding files compressed with LZMA or XZ utils.

%package 	compat-libs
Summary:	Compatibility libraries for decoding LZMA compression
Group:		System Environment/Libraries
License:	LGPLv2+

%description 	compat-libs
Compatibility libraries for decoding files compressed with LZMA or XZ utils.
This particular package ships libraries from %{compat_ver} as of 1st of April 2010.

%package 	devel
Summary:	Devel libraries & headers for liblzma
Group:		Development/Libraries
License:	LGPLv2+
Requires:	%{name}-libs = %{version}-%{release}
Requires:	pkgconfig

%description	devel
Devel libraries and headers for liblzma.

%package 	lzma-compat
Summary:	Older LZMA format compatibility binaries
Group:		Development/Libraries
# lz{grep,diff,more} are GPLv2+. Other binaries are LGPLv2+
License:	GPLv2+ and LGPLv2+
Requires:	%{name} = %{version}-%{release}
Obsoletes:	lzma < %{version}
Provides:	lzma = %{version}

%description	lzma-compat
The lzma-compat package contains compatibility links for older
commands that deal with the older LZMA format.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a1 -n %{name}-%{version}alpha -a 999
%patch81413 -p1 -b .fiv-tests
%patch95603 -p1 -b .fiv-tests
for i in `find . -name config.sub`; do
  perl -pi -e "s/ppc64-\*/ppc64-\* \| ppc64p7-\*/" $i
done

%build
CFLAGS="%{optflags} -D_FILE_OFFSET_BITS=64" \
CXXFLAGS="%{optflags} -D_FILE_OFFSET_BITS=64" \
%configure --disable-static
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}

pushd %{compat_ver}
%configure --disable-static
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}
popd

pushd tests/
make compile-tests
install .libs/* .
popd

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot} INSTALL="%{__install} -p"
rm -f %{buildroot}%{_libdir}/*.a
rm -f %{buildroot}%{_libdir}/*.la
rm -rf %{buildroot}%{_docdir}/%{name}
rm -rf %{buildroot}%{_datadir}/locale
cp -r %{compat_ver}/src/liblzma/.libs/liblzma.so.0* %{buildroot}%{_libdir}

# Steps to package the xz tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests

pushd tests
cp -rf files compress_prepared* $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
install create_compress_files test_*[^co] $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
popd

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
LD_LIBRARY_PATH=$PWD/src/liblzma/.libs make check

%clean
rm -rf %{buildroot}

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%post compat-libs -p /sbin/ldconfig

%postun compat-libs -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING* ChangeLog NEWS README THANKS TODO
%{_bindir}/*xz*
%{_mandir}/man1/*xz*

%files libs
%defattr(-,root,root,-)
%doc COPYING*
%{_libdir}/lib*.so.5*

%files compat-libs
%defattr(-,root,root,-)
%doc COPYING*
%{_libdir}/lib*.so.0*

%files devel
%defattr(-,root,root,-)
%dir %{_includedir}/lzma
%{_includedir}/lzma/*.h
%{_includedir}/lzma.h
%{_libdir}/*.so
%{_libdir}/pkgconfig/liblzma.pc

%files lzma-compat
%defattr(-,root,root,-)
%{_bindir}/*lz*
%{_mandir}/man1/*lz*

%files fivextra
%{prefix}

%changelog
* Mon May 20 2013 baseuser@ibm.com
- Base-8.x spec file
