%if 0%{?fedora} > 12 && ! 0%{?base:1}
%global with_python3 1
%else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%endif

# Enable building without docs to avoid a circular dependency between this
# and python-sphinx:
%if ! 0%{?base:1}
%global with_docs 1
%endif

Name:		python-jinja2
Version:	2.6
%define base_release .1
Release:	7%{?dist}%{?base_release}
ExcludeArch: mips64 ppc476 ppcnf ppca2
Summary:	General purpose template engine
Group:		Development/Languages
License:	BSD
URL:		http://jinja.pocoo.org/
Source0:	http://pypi.python.org/packages/source/J/Jinja2/Jinja2-%{version}.tar.gz
# This patch consists of two upstream patches merged and rebased
# (the first upstream patch introduced CVE-2014-0012 and the second fixed it)
# https://github.com/mitsuhiko/jinja2/commit/acb672b6a179567632e032f547582f30fa2f4aa7
# https://github.com/mitsuhiko/jinja2/pull/296/files
Patch0:		Jinja2-2.6-fix-CVE-2014-1402.patch
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch
BuildRequires:	python-devel
BuildRequires:	python-setuptools
BuildRequires:	python-markupsafe
%if 0%{?with_docs}
BuildRequires:	python-sphinx
%endif # with_docs
Requires:	python-babel >= 0.8
Requires:	python-markupsafe
%if 0%{?with_python3}
BuildRequires:	python3-devel
BuildRequires:	python3-setuptools
BuildRequires:	python3-markupsafe
%endif # with_python3


%description
Jinja2 is a template engine written in pure Python.  It provides a
Django inspired non-XML syntax but supports inline expressions and an
optional sandboxed environment.

If you have any exposure to other text-based template languages, such
as Smarty or Django, you should feel right at home with Jinja2. It's
both designer and developer friendly by sticking to Python's
principles and adding functionality useful for templating
environments.


%if 0%{?with_python3}
%package -n python3-jinja2
Summary:	General purpose template engine
Group:		Development/Languages
Requires:	python3-markupsafe
# babel isn't py3k ready yet, and is only a weak dependency
#Requires:	 python3-babel >= 0.8


%description -n python3-jinja2
Jinja2 is a template engine written in pure Python.  It provides a
Django inspired non-XML syntax but supports inline expressions and an
optional sandboxed environment.

If you have any exposure to other text-based template languages, such
as Smarty or Django, you should feel right at home with Jinja2. It's
both designer and developer friendly by sticking to Python's
principles and adding functionality useful for templating
environments.
%endif # with_python3


%prep
%setup -q -n Jinja2-%{version}
%patch0 -p0

# cleanup
find . -name '*.pyo' -o -name '*.pyc' -delete

# fix EOL
sed -i 's|\r$||g' LICENSE

%if 0%{?with_python3}
cp -a . %{py3dir}
%endif # with_python3


%build
%{__python} setup.py build

# for now, we build docs using Python 2.x and use that for both
# packages.
%if 0%{?with_docs}
make -C docs html
%endif # with_docs

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}
%{__python} setup.py install -O1 --skip-build \
	    --root %{buildroot}

# remove hidden file
rm -rf docs/_build/html/.buildinfo

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build \
	    --root %{buildroot}
popd
%endif # with_python3


%clean
rm -rf %{buildroot}


%check
make test


%if 0%{?with_python3}
pushd %{py3dir}
make test
popd
%endif # with_python3


%files
%defattr(-,root,root,-)
%doc AUTHORS CHANGES LICENSE
%if 0%{?with_docs}
%doc docs/_build/html
%endif # with_docs
%doc ext
%doc examples
%{python_sitelib}/*
%exclude %{python_sitelib}/jinja2/_debugsupport.c


%if 0%{?with_python3}
%files -n python3-jinja2
%defattr(-,root,root,-)
%doc AUTHORS CHANGES LICENSE
%if 0%{?with_docs}
%doc docs/_build/html
%endif # with_docs
%doc ext
%doc examples
%{python3_sitelib}/*
%exclude %{python3_sitelib}/jinja2/_debugsupport.c
%endif # with_python3


%changelog
* Thu Jul 31 2014 baseuser@ibm.com
- Base-8.x spec file
