Summary: Utilities for the IBM Power Linux RAID adapters
Name: iprutils
Version: 2.4.0
%define base_release .6
Release: 2%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: CPL
Group: System Environment/Base
Vendor: IBM
URL: http://sourceforge.net/projects/iprdd/
Source0: iprutils-%{version}-src.tgz
Patch1000: bug108739-fix.firmware.updating.patch
Patch1001: bug109025-systemd.services.patch
Patch1002: bug110193-fix.segfault.patch
Patch1003: bug111495-create.ipr.dump.file.patch
BuildRoot: %{_tmppath}/%{name}-root

Requires: /sbin/pidof
 
BuildRequires: libsysfs-devel
BuildRequires: pciutils-devel
BuildRequires: ncurses-devel
BuildRequires: libcap-devel

%description
Provides a suite of utilities to manage and configure SCSI devices
supported by the ipr SCSI storage device driver.

%prep
%setup -q -n %{name}
%patch1000 -p2
%patch1001 -p1
%patch1002 -p2
%patch1003 -p2

%build
make

%install
if [ -d %{_unitdir} ]; then
	make INSTALL_MOD_PATH=$RPM_BUILD_ROOT install
	install -d $RPM_BUILD_ROOT/%{_unitdir}
	install -m 644 systemd/iprinit.service $RPM_BUILD_ROOT/%{_unitdir}/iprinit.service
	install -m 644 systemd/iprdump.service $RPM_BUILD_ROOT/%{_unitdir}/iprdump.service
	install -m 644 systemd/iprupdate.service $RPM_BUILD_ROOT/%{_unitdir}/iprupdate.service
else
	make INSTALL_MOD_PATH=$RPM_BUILD_ROOT install
	install -d $RPM_BUILD_ROOT/%{_sysconfdir}/init.d
	install -m 755 init.d/iprinit $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/iprinit
	install -m 755 init.d/iprdump $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/iprdump
	install -m 755 init.d/iprupdate $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/iprupdate
fi

install -d $RPM_BUILD_ROOT/%{_sysconfdir}/ha.d
install -d $RPM_BUILD_ROOT/%{_sysconfdir}/ha.d/resource.d
install -m 755 init.d/iprha $RPM_BUILD_ROOT/%{_sysconfdir}/ha.d/resource.d/iprha

%ifarch ppc ppc64
%post
# if the system is using systemd
if [ -d %{_unitdir} ]; then
	if [ $1 = 2 ]; then
		echo "Restarting iprutils services"
		/usr/bin/systemctl restart iprinit.service > /dev/null 2>&1
		/usr/bin/systemctl restart iprupdate.service > /dev/null 2>&1
		/usr/bin/systemctl restart iprdump.service > /dev/null 2>&1
	else
		/usr/bin/systemctl daemon-reload > /dev/null 2>&1
		/usr/bin/systemctl enable iprinit.service > /dev/null 2>&1
		/usr/bin/systemctl enable iprdump.service > /dev/null 2>&1
		/usr/bin/systemctl enable iprupdate.service > /dev/null 2>&1
	fi

# if the system is not using systemd
else
	if [ $1 = 2 ]; then
		echo "Restarting iprutils services"
		%{_sysconfdir}/init.d/iprdump restart  > /dev/null 2>&1
		%{_sysconfdir}/init.d/iprupdate restart  > /dev/null 2>&1
		%{_sysconfdir}/init.d/iprinit restart  > /dev/null 2>&1
	elif [ -f /sbin/chkconfig ]; then
		/sbin/chkconfig --add iprinit > /dev/null 2>&1
		/sbin/chkconfig --add iprdump > /dev/null 2>&1
		/sbin/chkconfig --add iprupdate > /dev/null 2>&1
		/sbin/chkconfig iprinit on > /dev/null 2>&1
		/sbin/chkconfig iprdump on > /dev/null 2>&1
		/sbin/chkconfig iprupdate on > /dev/null 2>&1
	else
		/usr/lib/lsb/install_initd %{_sysconfdir}/init.d/iprinit
		/usr/lib/lsb/install_initd %{_sysconfdir}/init.d/iprdump
		/usr/lib/lsb/install_initd %{_sysconfdir}/init.d/iprupdate
	fi
fi
%endif

%ifarch ppc ppc64
%preun
# disable services if the system is using systemd
if [ -d %{_unitdir} ]; then
        if [ $1 = 0 ]; then
                echo "Restarting iprutils services"
                /usr/bin/systemctl stop iprinit.service > /dev/null 2>&1
                /usr/bin/systemctl stop iprupdate.service > /dev/null 2>&1
                /usr/bin/systemctl stop iprdump.service > /dev/null 2>&1
	else
                /usr/bin/systemctl disable iprinit.service > /dev/null 2>&1
                /usr/bin/systemctl disable iprdump.service > /dev/null 2>&1
                /usr/bin/systemctl disable iprupdate.service > /dev/null 2>&1
        fi

# disable services if the system is *not* using systemd
elif [ $1 = 0 ]; then
	%{_sysconfdir}/init.d/iprdump stop  > /dev/null 2>&1
	%{_sysconfdir}/init.d/iprupdate stop  > /dev/null 2>&1
	%{_sysconfdir}/init.d/iprinit stop  > /dev/null 2>&1

	if [ -f /sbin/chkconfig ]; then
		/sbin/chkconfig --del iprinit > /dev/null 2>&1
		/sbin/chkconfig --del iprdump > /dev/null 2>&1
		/sbin/chkconfig --del iprupdate > /dev/null 2>&1
	else
		/usr/lib/lsb/remove_initd %{_sysconfdir}/init.d/iprdump
		/usr/lib/lsb/remove_initd %{_sysconfdir}/init.d/iprupdate
		/usr/lib/lsb/remove_initd %{_sysconfdir}/init.d/iprinit
	fi
fi
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%if %{?_unitdir:1}%{!?_unitdir:0}
       %{_unitdir}/*
%else
       %{_sysconfdir}/init.d/*
%endif
%doc README LICENSE
/sbin/*
%{_mandir}/man*/*
%{_sysconfdir}/ha.d/resource.d/iprha

%changelog
* Fri Feb 21 2014 baseuser@ibm.com
- Base-f19.x spec file
