Summary: Lightweight library for embedding a webserver in applications
Name: libmicrohttpd
Version: 0.9.33
%define base_release .1
Release: 1%{?dist}%{?base_release}
Group: Development/Libraries
License: LGPLv2+
BuildRoot: %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
URL: http://www.gnu.org/software/libmicrohttpd/
Source0: ftp://ftp.gnu.org/gnu/libmicrohttpd/%{name}-%{version}.tar.gz

BuildRequires:  autoconf, automake, libtool
%if 0%{?rhel} == 5
BuildRequires:	curl-devel
%endif
%if 0%{?fedora} >= 11 || 0%{?rhel} >= 6
BuildRequires:	libcurl-devel
%endif
BuildRequires:  gnutls-devel
BuildRequires:  libgcrypt-devel
BuildRequires:  graphviz
BuildRequires:  doxygen

Requires(post): info
Requires(preun): info

%description
GNU libmicrohttpd is a small C library that is supposed to make it
easy to run an HTTP server as part of another application.
Key features that distinguish libmicrohttpd from other projects are:

* C library: fast and small
* API is simple, expressive and fully reentrant
* Implementation is http 1.1 compliant
* HTTP server can listen on multiple ports
* Support for IPv6
* Support for incremental processing of POST data
* Creates binary of only 25k (for now)
* Three different threading models

%package devel
Summary:        Development files for libmicrohttpd
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}

%description devel
Development files for libmicrohttpd

%package doc
Summary:        Documentation for libmicrohttpd
Group:          Documentation
Requires:       %{name} = %{version}-%{release}
%if 0%{?fedora} >= 11 || 0%{?rhel} >= 6
BuildArch:      noarch
%endif

%description doc
Doxygen documentation for libmicrohttpd and some example source code

%prep
%setup -q

%build
# Required because patches modify .am files
# autoreconf --force
%configure --disable-static --with-gnutls
make %{?_smp_mflags}
cd doc/doxygen && make full && cd -

# Disabled for now due to problems reported at
# https://gnunet.org/bugs/view.php?id=1619
#check
#make check %{?_smp_mflags}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}

rm -f %{buildroot}%{_libdir}/libmicrohttpd.la
rm -f %{buildroot}%{_infodir}/dir

# Install some examples in /usr/share/doc/libmicrohttpd-${version}/examples
mkdir examples
install -m 644 src/examples/*.c examples

# Install the doxygen documentation in /usr/share/doc/libmicrohttpd-${version}/html
cp -R doc/doxygen/html html

%clean
rm -rf %{buildroot}

%post doc
/sbin/install-info %{_infodir}/libmicrohttpd.info.gz %{_infodir}/dir || :
/sbin/install-info %{_infodir}/libmicrohttpd-tutorial.info.gz %{_infodir}/dir || :

%preun doc
if [ $1 = 0 ] ; then
/sbin/install-info --delete %{_infodir}/libmicrohttpd.info.gz %{_infodir}/dir || :
/sbin/install-info --delete %{_infodir}/libmicrohttpd-tutorial.info.gz %{_infodir}/dir || :
fi

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/libmicrohttpd.so.*

%files devel
%defattr(-,root,root,-)
%{_includedir}/microhttpd.h
%{_libdir}/libmicrohttpd.so
%{_libdir}/pkgconfig/libmicrohttpd.pc

%files doc
%defattr(-,root,root,-)
%{_mandir}/man3/libmicrohttpd.3.gz
%{_infodir}/libmicrohttpd.info.gz
%{_infodir}/libmicrohttpd-tutorial.info.gz
%doc AUTHORS README ChangeLog
%doc examples
%doc html

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
