%define name lsvpd
%define version 1.7.4

Name:		%{name}
Version:	%{version}
%define base_release .6
Release:	1%{?dist}%{?base_release}
Summary:	VPD/hardware inventory utilities for Linux

Group:		Applications/System
License:	GPLv2+
URL:		http://linux-diag.sf.net/Lsvpd.html
Source0:	http://downloads.sourceforge.net/linux-diag/%{name}-%{version}.tar.gz
Patch0:		lsvpd-1.7.4-fix-license-issue.patch
#Patch1:		lsvpd-1.6.7-ids-lookup.patch
# invscout command is shipped in IBMinvscout package, which
# is not yet exist in Fedora. Hence exclude building invscout.
#Patch2:		lsvpd-1.7.1-exclude_invscout.patch
#Patch99:	bug104102.display.firmware.patch
#Patch100:	bug104102.filter.directories.patch
#Patch101:	bug104102.platform.collector.patch
#Patch102:	bug104102.opal.collector.patch
#Patch103:	bug104102.rtas.collector.patch
#Patch104:	bug104102.devicetree.collector.patch
#Patch105:	bug104102.makefile.updates.patch
#Patch106:	bug104102.vpdupdate.patch
#Patch107:	bug104102.platform.check.patch
#Patch108:	bug104102.lsmcode.patch
#Patch109:	bug104102.lscfg.patch
#Patch110:	bug104102.lsvio.patch
#Patch111:	bug104102.more.makefile.updates.patch
#Patch112:	bug105050.out.of.range.fix.patch
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:	libvpd-devel >= 2.2.1
BuildRequires:	sg3_utils-devel zlib-devel automake libtool
BuildRequires:	librtas-devel
Requires(post): /usr/sbin/vpdupdate

ExclusiveArch: ppc ppc64

%description
The lsvpd package contains all of the lsvpd, lscfg and lsmcode
commands. These commands, along with a scanning program
called vpdupdate, constitute a hardware inventory
system. The lsvpd command provides Vital Product Data (VPD) about
hardware components to higher-level serviceability tools. The lscfg
command provides a more human-readable format of the VPD, as well as
some system-specific information.  lsmcode lists microcode and
firmware levels.  lsvio lists virtual devices, usually only found
on POWER PC based systems.

%prep
%setup -q
%patch0 -p1 -b .fix-license-issue
#%patch1 -p0 -b .lookup
#%patch2 -p1 -b .exclude_invscout
# Patches from bug #104102
#%patch99 -p1
#%patch100 -p1
#%patch101 -p1
#%patch102 -p1
#%patch103 -p1
#%patch104 -p1
#%patch105 -p1
#%patch106 -p1
#%patch107 -p1
#%patch108 -p1
#%patch109 -p1
#%patch110 -p1
#%patch111 -p1

# bug 105050
#%patch112 -p1

%build
./bootstrap.sh
%configure
%{__make} %{?_smp_mflags}

%clean 
%{__rm} -rf $RPM_BUILD_ROOT

%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT

%post -p /usr/sbin/vpdupdate

%files 
%defattr(-,root,root,-)
%doc COPYING INSTALL NEWS README
%{_sbindir}/lsvpd
%{_sbindir}/lscfg
%{_sbindir}/lsmcode
%{_sbindir}/lsvio
%{_sbindir}/vpdupdate
%{_mandir}/man8/vpdupdate.8.gz
%{_mandir}/man8/lsvpd.8.gz
%{_mandir}/man8/lscfg.8.gz
%{_mandir}/man8/lsvio.8.gz
%{_mandir}/man8/lsmcode.8.gz
%config %{_sysconfdir}/lsvpd/scsi_templates.conf
%config %{_sysconfdir}/lsvpd/cpu_mod_conv.conf
%dir %{_sysconfdir}/lsvpd

%changelog
* Wed Aug 28 2013 baseuser@ibm.com
- Base-8.x spec file
