Summary: Bluetooth utilities
Name: bluez
Version: 4.101
%define base_release .1
Release: 9%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2+
Group: Applications/System
URL: http://www.bluez.org/

Source: http://www.kernel.org/pub/linux/bluetooth/%{name}-%{version}.tar.gz
Source1: bluez.gitignore
Source3: dund.init
Source4: dund.conf
Source5: pand.init
Source6: pand.conf
Source7: rfcomm.init
Source8: bluez-uinput.modules

# https://bugzilla.redhat.com/show_bug.cgi?id=964031
Patch0: 0001-Allow-PulseAudio-to-connect-by-default.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=877998
Patch1: 0001-hid2hci-change-subsystem-in-udev-rule-from-usb-to-us.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=498756
Patch4: 0001-Activate-the-Socket-Mobile-CF-kit.patch
# http://thread.gmane.org/gmane.linux.bluez.kernel/2396
Patch5: 0001-Add-sixaxis-cable-pairing-plugin.patch
# PS3 BD Remote patches
Patch6: 0001-input-Add-helper-function-to-request-disconnect.patch
Patch7: 0002-fakehid-Disconnect-from-PS3-remote-after-10-mins.patch
Patch8: 0003-fakehid-Use-the-same-constant-as-declared.patch
# Upstream patches
Patch9: 0001-audio-Permit-concurrent-use-of-AG-and-HF-roles.patch
Patch10: 0001-Fix-GDBus-flags-after-conversion-to-macros.patch
Patch11: 0001-input-Fix-not-adding-watches-when-io-channel-is-conn.patch
Patch12: 0001-network-fix-network-Connect-method-parameters.patch
Patch13: 0001-network-NULL-dereference-fix.patch
# Ubuntu patches
Patch14: 0001-work-around-Logitech-diNovo-Edge-keyboard-firmware-i.patch
Patch15: 0001-Enable-the-Gateway-and-Source-audio-profiles-by-defa.patch

BuildRequires: git
BuildRequires: flex
BuildRequires: dbus-devel >= 0.90
BuildRequires: libusb-devel, glib2-devel, alsa-lib-devel
BuildRequires: gstreamer-plugins-base-devel, gstreamer-devel
BuildRequires: libsndfile-devel
BuildRequires: libcap-ng-devel
BuildRequires: readline-devel
# For cable pairing
BuildRequires: systemd-devel
# For cups
BuildRequires: cups-devel
%ifnarch s390 s390x
BuildRequires: libusbx-devel
%endif

# For rebuild
BuildRequires: libtool autoconf automake

Requires: bluez-libs = %{version}-%{release}
Requires: systemd
Requires: dbus >= 0.60
Requires: hwdata >= 0.215
%ifnarch s390 s390x
Requires: dbus-bluez-pin-helper
%endif
Requires(preun): /bin/systemctl
Requires(post): /bin/systemctl

%description
Utilities for use in Bluetooth applications:
	- hcitool
	- hciattach
	- hciconfig
	- bluetoothd
	- l2ping
	- start scripts (Red Hat)
	- pcmcia configuration files

The BLUETOOTH trademarks are owned by Bluetooth SIG, Inc., U.S.A.

%package libs
Summary: Libraries for use in Bluetooth applications
Group: System Environment/Libraries

%package libs-devel
Summary: Development libraries for Bluetooth applications
Group: Development/Libraries
Requires: bluez-libs = %{version}-%{release}
Requires: pkgconfig

%package cups
Summary: CUPS printer backend for Bluetooth printers
Group: System Environment/Daemons
Requires: bluez-libs = %{version}-%{release}
Requires: cups

%package gstreamer
Summary: GStreamer support for SBC audio format
Group: System Environment/Daemons
Requires: bluez-libs = %{version}-%{release}

%package alsa
Summary: ALSA support for Bluetooth audio devices
Group: System Environment/Daemons
Requires: bluez-libs = %{version}-%{release}

%package compat
Summary: Compatibility utilities for Bluetooth devices
Group: System Environment/Daemons
Requires: bluez-libs = %{version}-%{release}
Requires: bluez = %{version}-%{release}
Requires(preun): /sbin/chkconfig, /sbin/service
Requires(post): /sbin/chkconfig, /sbin/service

%package hid2hci
Summary: Put HID proxying bluetooth HCI's into HCI mode
Group: System Environment/Daemons
Requires: bluez-libs = %{version}-%{release}
Requires: bluez = %{version}-%{release}

%description cups
This package contains the CUPS backend

%description gstreamer
This package contains gstreamer plugins for the Bluetooth SBC audio format

%description alsa
This package contains ALSA support for Bluetooth audio devices

%description libs
Libraries for use in Bluetooth applications.

%description libs-devel
bluez-libs-devel contains development libraries and headers for
use in Bluetooth applications.

%description compat
This package contains compatibility utilities for Bluetooth devices.
This includes hidd, dund and pand.

%description hid2hci
Most allinone PC's and bluetooth keyboard / mouse sets which include a
bluetooth dongle, ship with a so called HID proxying bluetooth HCI.
The HID proxying makes the keyboard / mouse show up as regular USB HID
devices (after connecting using the connect button on the device + keyboard),
which makes them work without requiring any manual configuration.

The bluez-hid2hci package contains the hid2hci utility and udev rules to
automatically switch supported Bluetooth devices into regular HCI mode.

Install this package if you want to use the bluetooth function of the HCI
with other bluetooth devices like for example a mobile phone.

Note that after installing this package you will first need to pair your
bluetooth keyboard and mouse with the bluetooth adapter before you can use
them again. Since you cannot use your bluetooth keyboard and mouse until
they are paired, this will require the use of a regular (wired) USB keyboard
and mouse.

%prep

%setup -q
git init
if [ -z "$GIT_COMMITTER_NAME" ]; then
    git config user.email "bluez-owner@fedoraproject.org"
    git config user.name "Fedora Bluez maintainers"
fi
cp %{SOURCE1} .gitignore
git add .
git commit -a -q -m "%{version} baseline."

git am -p1 %{patches} < /dev/null

rm -rf .git/*
%build
libtoolize -f -c
autoreconf -vif
%configure --enable-cups --enable-dfutool --enable-tools --enable-bccmd --enable-gstreamer --enable-hidd --enable-pand --enable-dund --enable-hid2hci --with-ouifile=/usr/share/hwdata/oui.txt --with-systemdsystemunitdir=/lib/systemd/system --enable-wiimote
make V=1

%install
make install DESTDIR=$RPM_BUILD_ROOT
/sbin/ldconfig -n $RPM_BUILD_ROOT/%{_libdir}
# Remove autocrap and libtool droppings
rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la				\
	$RPM_BUILD_ROOT/%{_libdir}/alsa-lib/*.la		\
	$RPM_BUILD_ROOT/%{_libdir}/bluetooth/plugins/*.la	\
	$RPM_BUILD_ROOT/%{_libdir}/gstreamer-0.10/*.la

for a in dund pand rfcomm ; do
	install -D -m0755 $RPM_SOURCE_DIR/$a.init $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/$a
	if [ -e $RPM_SOURCE_DIR/$a.conf ] ; then
		install -D -m0644 $RPM_SOURCE_DIR/$a.conf $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/$a
	fi
done

# Remove the cups backend from libdir, and install it in /usr/lib whatever the install
if test -d ${RPM_BUILD_ROOT}/usr/lib64/cups ; then
	install -D -m0755 ${RPM_BUILD_ROOT}/usr/lib64/cups/backend/bluetooth ${RPM_BUILD_ROOT}%_cups_serverbin/backend/bluetooth
	rm -rf ${RPM_BUILD_ROOT}%{_libdir}/cups
fi

rm -f ${RPM_BUILD_ROOT}/%{_sysconfdir}/udev/*.rules ${RPM_BUILD_ROOT}/lib/udev/rules.d/*.rules
install -D -p -m0644 scripts/bluetooth-serial.rules ${RPM_BUILD_ROOT}/lib/udev/rules.d/97-bluetooth-serial.rules
install -D -p -m0644 scripts/bluetooth-hid2hci.rules ${RPM_BUILD_ROOT}/lib/udev/rules.d/97-bluetooth-hid2hci.rules
install -D -m0755 scripts/bluetooth_serial ${RPM_BUILD_ROOT}/lib/udev/bluetooth_serial

install -D -m0755 %{SOURCE8} $RPM_BUILD_ROOT/%{_sysconfdir}/sysconfig/modules/bluez-uinput.modules

install -d -m0755 $RPM_BUILD_ROOT/%{_localstatedir}/lib/bluetooth

mkdir -p $RPM_BUILD_ROOT/%{_libdir}/bluetooth/

install -D -p -m0644 audio/audio.conf ${RPM_BUILD_ROOT}/etc/bluetooth/

%post libs -p /sbin/ldconfig

%post
if [ $1 -eq 1 ]; then
	/bin/systemctl enable bluetooth.service >/dev/null 2>&1 || :
fi

%postun libs -p /sbin/ldconfig

%preun
if [ $1 -eq 0 ]; then
        /bin/systemctl --no-reload disable bluetooth.service >/dev/null 2>&1 || :
        /bin/systemctl stop bluetooth.service >/dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
        /bin/systemctl try-restart bluetooth.service >/dev/null 2>&1 || :
fi

%triggerun -- bluez < 4.94-4
/bin/systemctl --no-reload enable bluetooth.service >/dev/null 2>&1 || :

%post compat
/sbin/chkconfig --add dund
/sbin/chkconfig --add pand
/sbin/chkconfig --add rfcomm
if [ "$1" -ge "1" ]; then
	/sbin/service dund condrestart >/dev/null 2>&1 || :
	/sbin/service pand condrestart >/dev/null 2>&1 || :
	/sbin/service rfcomm condrestart >/dev/null 2>&1 || :
fi
exit 0

%preun compat
if [ "$1" = "0" ]; then
	/sbin/service dund stop >/dev/null 2>&1 || :
	/sbin/service pand stop >/dev/null 2>&1 || :
	/sbin/service rfcomm stop >/dev/null 2>&1 || :
	/sbin/chkconfig --del dund
	/sbin/chkconfig --del pand
	/sbin/chkconfig --del rfcomm
fi

%post hid2hci
/sbin/udevadm trigger --subsystem-match=usb

%files
%defattr(-,root,root,-)
%{_bindir}/ciptool
%{_bindir}/dfutool
%{_bindir}/hcitool
%{_bindir}/l2ping
%{_bindir}/rfcomm
%{_bindir}/sdptool
%{_bindir}/gatttool
%{_sbindir}/*
%{_mandir}/man1/ciptool.1.gz
%{_mandir}/man1/dfutool.1.gz
%{_mandir}/man1/hcitool.1.gz
%{_mandir}/man1/rfcomm.1.gz
%{_mandir}/man1/sdptool.1.gz
%{_mandir}/man8/*
%exclude %{_mandir}/man8/hid2hci.8*
%dir %{_sysconfdir}/bluetooth/
%config(noreplace) %{_sysconfdir}/bluetooth/main.conf
%config(noreplace) %{_sysconfdir}/bluetooth/audio.conf
%config(noreplace) %{_sysconfdir}/sysconfig/modules/bluez-uinput.modules
%config %{_sysconfdir}/dbus-1/system.d/bluetooth.conf
%{_libdir}/bluetooth/
/lib/udev/bluetooth_serial
/lib/udev/rules.d/97-bluetooth-serial.rules
%{_localstatedir}/lib/bluetooth
%{_datadir}/dbus-1/system-services/org.bluez.service
/usr/lib/systemd/system/bluetooth.service

%files libs
%defattr(-,root,root,-)
%{_libdir}/libbluetooth.so.*
%doc AUTHORS COPYING INSTALL ChangeLog README

%files libs-devel
%defattr(-,root,root,-)
%{_libdir}/libbluetooth.so
%dir %{_includedir}/bluetooth
%{_includedir}/bluetooth/*
%{_libdir}/pkgconfig/bluez.pc

%files cups
%defattr(-,root,root,-)
%_cups_serverbin/backend/bluetooth

%files gstreamer
%defattr(-,root,root,-)
%{_libdir}/gstreamer-*/*.so

%files alsa
%defattr(-,root,root,-)
%{_libdir}/alsa-lib/*.so
%{_datadir}/alsa/bluetooth.conf

%files compat
%defattr(-,root,root,-)
%{_bindir}/dund
%{_bindir}/pand
%{_bindir}/hidd
%config(noreplace) %{_sysconfdir}/bluetooth/rfcomm.conf
%{_sysconfdir}/rc.d/init.d/dund
%{_sysconfdir}/rc.d/init.d/rfcomm
%{_sysconfdir}/rc.d/init.d/pand
%config(noreplace) %{_sysconfdir}/sysconfig/dund
%config(noreplace) %{_sysconfdir}/sysconfig/pand
%{_mandir}/man1/dund.1.gz
%{_mandir}/man1/hidd.1.gz
%{_mandir}/man1/pand.1.gz

%files hid2hci
%defattr(-,root,root,-)
/usr/lib/udev/hid2hci
%{_mandir}/man8/hid2hci.8*
/lib/udev/rules.d/97-bluetooth-hid2hci.rules
%exclude /usr/lib/udev/rules.d/97-bluetooth-hid2hci.rules

%changelog
* Wed Jan 29 2014 baseuser@ibm.com
- Base-f19.x spec file
