Name:           libqb
Version:        0.14.4
%define base_release .2
Release:        2%{?dist}%{?base_release}
Summary:        An IPC library for high performance servers

Group:          System Environment/Libraries
License:        LGPLv2+
URL:            http://www.libqb.org
Source0:        https://fedorahosted.org/releases/q/u/quarterback/%{name}-%{version}.tar.xz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  libtool doxygen procps check-devel automake

#Requires: <nothing>

%description
libqb provides high performance client server reusable features.
Initially these are IPC and poll.

%prep
%setup -q

# work-around for broken epoll in rawhide/f17
%build
%configure --disable-static ac_cv_func_epoll_create1=no ac_cv_func_epoll_create=no
make %{?_smp_mflags}

%check
make check

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'
rm -rf $RPM_BUILD_ROOT/%{_docdir}/*

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING
%{_sbindir}/qb-blackbox
%{_libdir}/libqb.so.*

%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release} pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%files          devel
%defattr(-,root,root,-)
%doc COPYING README.markdown
%{_includedir}/qb/
%{_libdir}/libqb.so
%{_libdir}/pkgconfig/libqb.pc
%{_mandir}/man3/qb*3*
%{_mandir}/man8/qb-blackbox.8.gz

%changelog
* Thu May 23 2013 baseuser@ibm.com
- Base-8.x spec file
