Summary:     The mdadm program controls Linux md devices (software RAID arrays)
Name:        mdadm
Version:     3.2.6
%define base_release .2
Release:     21%{?dist}%{?base_release}
Source:      http://www.kernel.org/pub/linux/utils/raid/mdadm/mdadm-%{version}.tar.xz
Source1:     mdmonitor.init
Source2:     raid-check
Source3:     mdadm.rules
Source4:     mdadm-raid-check-sysconfig
Source5:     mdadm-cron
Source6:     mdmonitor.service
Source7:     mdadm.conf
Source8:     mdadm_event.conf
Source999:   fivextra.tar.bz2
Patch1:	     mdadm-3.2.6-Create.c-check-if-freesize-is-equal-0.patch
Patch2:	     mdadm-3.2.6-imsm-Forbid-spanning-between-multiple-controllers.patch
Patch3:	     mdadm-3.2.6-query-udev-dir-via-pkg-config.patch
Patch4:	     mdadm-3.2.6-Add-updating-component_size-to-manager-thread-of-mdm.patch
Patch5:      mdadm-3.2.6-imsm-monitor-do-not-finish-migration-if-there-are-no.patch
Patch6:      mdadm-3.2.6-Manage_runstop-call-flush_mdmon-if-O_EXCL-fails-on-s.patch
Patch93:     mdadm-3.2.6-Remove-offroot-argument-and-default-to-always-settin.patch
Patch94:     mdadm-3.2.6-Add-support-for-launching-mdmon-via-systemctl-instea.patch
Patch95:     mdadm-3.2.6-In-case-launching-mdmon-fails-print-an-error-message.patch
Patch96:     mdadm-3.2.6-mdmon-add-foreground-option.patch
# Fedora customization patches
Patch97:     mdadm-3.2.6-udev.patch
Patch98:     mdadm-2.5.2-static.patch
# Fedora 17 - only
Patch99:     mdadm-3.2.4-map-dir.patch
URL:         http://www.kernel.org/pub/linux/utils/raid/mdadm/
License:     GPLv2+
Group:       System Environment/Base
BuildRoot:   %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Obsoletes:   mdctl,raidtools
Obsoletes:   mdadm-sysvinit
Conflicts:   dracut < 024-25
Requires(post): systemd-units chkconfig coreutils
BuildRequires: systemd-units binutils-devel
Requires(preun): systemd-units
Requires(postun): systemd-units coreutils
Requires: libreport-filesystem

%description 
The mdadm program is used to create, manage, and monitor Linux MD (software
RAID) devices.  As such, it provides similar functionality to the raidtools
package.  However, mdadm is a single program, and it can perform
almost all functions without a configuration file, though a configuration
file can be used to help with some common tasks.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Requires: postfix
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999
%patch1 -p1 -b .raidsize
%patch2 -p1 -b .multictrl
%patch3 -p1 -b .udevquery
%patch4 -p1 -b .component
%patch5 -p1 -b .migration
%patch6 -p1 -b .runstop

# Use systemctl to launch mdmon on F18 and higher
%patch93 -p1 -b .nooffroot
%patch94 -p1 -b .sysctl
%patch95 -p1 -b .mdmonfail
%patch96 -p1 -b .foreground

# Fedora customization patches
%patch97 -p1 -b .udev
%patch98 -p1 -b .static

%build
make CC=%{__cc} %{?_smp_mflags} CXFLAGS="$RPM_OPT_FLAGS" SYSCONFDIR="%{_sysconfdir}" mdadm mdmon

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} MANDIR=%{_mandir} BINDIR=%{_sbindir} SYSTEMD_DIR=%{_unitdir} install install-systemd
install -Dp -m 755 %{SOURCE2} %{buildroot}%{_sbindir}/raid-check
install -Dp -m 644 %{SOURCE3} %{buildroot}%{_udevrulesdir}/65-md-incremental.rules
install -Dp -m 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/sysconfig/raid-check
install -Dp -m 644 %{SOURCE5} %{buildroot}%{_sysconfdir}/cron.d/raid-check
mkdir -p -m 700 %{buildroot}/var/run/mdadm

# systemd
mkdir -p %{buildroot}%{_unitdir}
install -m644 %{SOURCE6} %{buildroot}%{_unitdir}

# tmpfile
mkdir -p %{buildroot}%{_tmpfilesdir}
install -m 0644 %{SOURCE7} %{buildroot}%{_tmpfilesdir}/%{name}.conf
mkdir -p %{buildroot}%{_localstatedir}/run/
install -d -m 0710 %{buildroot}%{_localstatedir}/run/%{name}/

# abrt
mkdir -p %{buildroot}/etc/libreport/events.d
install -m644 %{SOURCE8} %{buildroot}/etc/libreport/events.d

# Steps to package the mdadm tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf %{buildroot}

%post
%systemd_post mdmonitor.service
/usr/bin/systemctl disable mdmonitor-takeover.service  >/dev/null 2>&1 || :

%preun
%systemd_preun mdmonitor.service

%postun
%systemd_postun_with_restart mdmonitor.service

%triggerun --  %{name} < 3.2.2-3
%{_bindir}/systemd-sysv-convert --save mdmonitor >/dev/null 2>&1 || :
/bin/systemctl --no-reload enable mdmonitor.service  >/dev/null 2>&1 || :
/sbin/chkconfig --del mdmonitor >/dev/null 2>&1 || :
/bin/systemctl try-restart mdmonitor.service >/dev/null 2>&1 || :

%files
%defattr(-,root,root,-)
%doc TODO ChangeLog mdadm.conf-example COPYING misc/*
%{_udevrulesdir}/*
%{_sbindir}/*
%{_unitdir}/*
%{_mandir}/man*/md*
%config(noreplace) %{_sysconfdir}/cron.d/*
%config(noreplace) %{_sysconfdir}/sysconfig/*
%dir %{_localstatedir}/run/%{name}/
%config(noreplace) %{_tmpfilesdir}/%{name}.conf
/etc/libreport/events.d/*

%files fivextra
%{prefix}
%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
