Summary:	Tools for monitoring SMART capable hard disks
Name:		smartmontools
Version:	6.2
%define base_release .2
Release:	2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Epoch:		1
Group:		System Environment/Base
License:	GPLv2+
URL:		http://smartmontools.sourceforge.net/
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Source2:	smartmontools.sysconf
Source4:        smartdnotify
Source999:     fivextra.tar.bz2

#fedora/rhel specific
Patch1:		smartmontools-5.38-defaultconf.patch

BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Requires:	fileutils mailx chkconfig
#new rpm does not handle this (yet?)
#Requires(triggerun):	systemd-units
Requires(post):		systemd-units
Requires(preun):	systemd-units
Requires(postun):	systemd-units
BuildRequires:	readline-devel ncurses-devel automake util-linux groff gettext
BuildRequires:	libselinux-devel libcap-ng-devel
BuildRequires:	systemd-units

%description
The smartmontools package contains two utility programs (smartctl
and smartd) to control and monitor storage systems using the Self-
Monitoring, Analysis and Reporting Technology System (SMART) built
into most modern ATA and SCSI hard disks. In many cases, these
utilities will provide advanced warning of disk degradation and
failure.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch1 -p1 -b .defaultconf

# fix encoding
for fe in AUTHORS ChangeLog
do
  iconv -f iso-8859-1 -t utf-8 <$fe >$fe.new
  touch -r $fe $fe.new
  mv -f $fe.new $fe
done

%build
autoreconf -i
%configure --with-selinux --with-libcap-ng=yes --with-systemdsystemunitdir=%{_unitdir} --sysconfdir=%{_sysconfdir}/%name/
%ifarch sparc64
make CXXFLAGS="$RPM_OPT_FLAGS -fPIE" LDFLAGS="-pie -Wl,-z,relro,-z,now"
%else
make CXXFLAGS="$RPM_OPT_FLAGS -fpie" LDFLAGS="-pie -Wl,-z,relro,-z,now"
%endif

sed -i 's|/etc/smartmontools/sysconfig|/etc/sysconfig|g' smartd.service

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

#rm -f $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/smartd.conf
rm -f examplescripts/Makefile*
chmod a-x -R examplescripts/*
install -D -p -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/smartmontools
install -D -p -m 755 %{SOURCE4} $RPM_BUILD_ROOT/%{_libexecdir}/%{name}/smartdnotify
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/%{name}/smartd_warning.d
rm -rf $RPM_BUILD_ROOT/etc/{rc.d,init.d}
rm -rf $RPM_BUILD_ROOT/%{_docdir}/%{name}

#steps to package the smartmontools test for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
      do
        install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
        install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
      done 

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install

%clean
rm -rf $RPM_BUILD_ROOT

%preun
%systemd_preun smartd.service

%pre
if [ $1 = 2 ] # only during update
then
  # for Fedora 19-22
  if [ -f %{_sysconfdir}/smartd.conf -a ! -e %{_sysconfdir}/%name ]
  then
    mkdir -p %{_sysconfdir}/%{name}
    cp -p %{_sysconfdir}/smartd.conf %{_sysconfdir}/%{name}
  fi
fi

%post
%systemd_post smartd.service

%postun
%systemd_postun_with_restart smartd.service

%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%doc TODO WARNINGS examplescripts smartd.conf
%dir %{_sysconfdir}/%name
%dir %{_sysconfdir}/%name/smartd_warning.d
%config(noreplace) %{_sysconfdir}/%{name}/smartd.conf
%config(noreplace) %{_sysconfdir}/%{name}/smartd_warning.sh
%config(noreplace) %{_sysconfdir}/sysconfig/smartmontools
%{_unitdir}/smartd.service
%{_sbindir}/smartd
%{_sbindir}/update-smart-drivedb
%{_sbindir}/smartctl
%{_mandir}/man?/smart*.*
%{_libexecdir}/%{name}
%{_datadir}/%{name}

%files fivextra
%{prefix} 

%changelog
* Tue Oct 15 2013 baseuser@ibm.com
- Base-8.x spec file
