Summary: Linux bootloader for Power Macintosh "New World" computers.
Name: yaboot
Version: 1.3.17
%define base_release .3
Release: 7%{?dist}%{?base_release}
License: GPLv2+
Group: System Environment/Base
Source: http://yaboot.ozlabs.org/releases/yaboot-%{version}.tar.gz
Source1: efika.forth
Patch1: yaboot-1.3.3-man.patch
Patch2: yaboot-1.3.6-ofboot.patch
Patch3: yaboot-1.3.6-rh.patch
Patch4: yaboot-1.3.13-yabootconfig.patch
Patch6: yaboot-1.3.10-proddiscover.patch
Patch7: yaboot-1.3.10-ext3.patch
Patch8: yaboot-1.3.10-sbindir.patch
Patch9: yaboot-1.3.10-configfile.patch
Patch10: yaboot-1.3.10-parted.patch
Patch17: yaboot-1.3.13-pegasos-claim.patch
Patch18: yaboot-1.3.13-pegasos-ext2.patch
Patch21: yaboot-1.3.13-pegasos-serial.patch
Patch22: yaboot-1.3.13-allow-deep-mntpoint.patch
Patch28: yaboot-1.3.13-dontwritehome.patch

# Don't use insecure MD5, use SHA-2
Patch40: yaboot-sha2.patch

# Do not use Werror, the compiler in F16/Rawhide is hitting warnings that
# Upstream doesn't see.  Bypass them for now.
Patch41: yaboot-1.3.17-no-werror.patch
# When booted from a cdrom the fs_swap would exit with FILE_ERR_BADDEV,
# this causes fs_open to abort too early and breaks booting from DVD
Patch42: yaboot-1.3.17-fs_swap.patch
Patch43: yaboot-1.3.17-link_with_new_e2fsprogs.patch
Patch44: yaboot-1.3.17-link_with_new_e2fsprogs2.patch
Patch45: yaboot-1.3.17-increase_load_buffer.patch

URL: http://yaboot.ozlabs.org/
BuildRoot: %{_tmppath}/%{name}-root
Obsoletes: ybin
ExclusiveArch: ppc

# hfsutils will not be in RHEL6.
# hfsutils is needed only for non-IBM ppc machines
#%if 0%{?fedora} || 0%{?rhel} < 6
%if ! 0%{?base}
Requires: hfsutils
%endif
BuildRequires: e2fsprogs-static

# yaboot is bootloader. It contains ELF object, but it is not Linux or MacOS
# executable file. Yaboot is meant to be executed only by OpenFirmware.
# So debuginfo rpm is nonsense
%global debug_package %{nil}

%description
yaboot is a bootloader for PowerPC machines which works on New World ROM
machines (Rev. A iMac and newer) and runs directly from Open Firmware,
eliminating the need for Mac OS.
yaboot can also bootload IBM pSeries machines.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch17 -p1
%patch18 -p1
%patch21 -p1
%patch22 -p1
%patch28 -p1
%patch40 -p1
%patch41 -p1
%patch42 -p1
%patch43 -p1
%patch44 -p1
%patch45 -p1

%build
make VERSIONEXTRA='\ (Base %version-%release)' DEBUG=1
cp -a second/yaboot{,.debug}
make clean
make VERSIONEXTRA='\ (Base %version-%release)'

%install
%makeinstall ROOT=$RPM_BUILD_ROOT PREFIX=%{_prefix} MANDIR=share/man SBINDIR=/sbin
rm -f $RPM_BUILD_ROOT/etc/yaboot.conf
touch $RPM_BUILD_ROOT/etc/yaboot.conf
mkdir -p $RPM_BUILD_ROOT/boot
install -m0644 %{SOURCE1} $RPM_BUILD_ROOT/boot/efika.forth
install -m0644 second/yaboot.debug $RPM_BUILD_ROOT/usr/lib/yaboot/

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc COPYING README* doc/*
/boot/efika.forth
/sbin/ofpath
/sbin/ybin
/sbin/yabootconfig
/sbin/mkofboot
/usr/lib/yaboot/addnote
/usr/lib/yaboot/ofboot
/usr/lib/yaboot/yaboot
/usr/lib/yaboot/yaboot.debug
%{_mandir}/man8/bootstrap.8.gz
%{_mandir}/man8/mkofboot.8.gz
%{_mandir}/man8/ofpath.8.gz
%{_mandir}/man8/yaboot.8.gz
%{_mandir}/man8/yabootconfig.8.gz
%{_mandir}/man8/ybin.8.gz
%{_mandir}/man5/yaboot.conf.5.gz
%ghost %config(noreplace) %{_sysconfdir}/yaboot.conf

%changelog
* Fri Jul 26 2013 baseuser@ibm.com
- Base-8.x spec file
