Name: busybox
Summary: Toolkit providing simplified versions of system commands
Version: 1.21.1
%define base_release .6
Release: 1%{?base_release}%{?dist}
Epoch: 1
License: GPLv2
Group: System Environment/Shells
Source: http://www.busybox.net/downloads/%{name}-%{version}.tar.bz2
Source1: base-config_1.18.3
Source2: busybox-petitboot.config
#ource3: http://www.uclibc.org/downloads/uClibc-0.9.30.1.tar.bz2
Source4: busybox-static.config
Patch16: busybox-1.10.1-hwclock.patch

# Base patches
Source7: busybox.mklinks
Source999: fivextra.tar.bz2
Patch32956: bug32956_busybox_add_obfuscate_tools_v1.21.patch
Patch329561: bug329561_mmkinitrd_busybox_find_cdroms_v1.21.patch
Patch74876: bug-74876-ignore_stdin_if_server.patch
Patch84937: bug84937-remove-MINIX-fs-support1.diff

#Skiboot patches
%if "%{?dist}" == ".skiboot1_0"
Patch99578: bug99578_add_config_file_option.patch
%endif

#IOMC patches
%if "%{?dist}" == ".iomc_harrier"
Patch79503:	bug-79503-fsh.patch
%endif

# Base customer specific busybox configs:

Obsoletes: busybox-anaconda
URL: http://www.busybox.net
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libselinux-devel >= 1.27.7-2
BuildRequires: libsepol-devel
BuildRequires: libselinux-static
BuildRequires: libsepol-static
BuildRequires: glibc-static fakeroot-tools ibm-obfuscate-devel
# Needed for busybox-config's with CONFIG_PAM set:
BuildRequires: pam-devel

%package petitboot
Group: System Environment/Shells
Summary: Version of busybox configured for use with petitboot

%package static
Group: System Environment/Shells
Summary: Static build of busybox

%description
Busybox is a single binary which includes versions of a large number
of system commands, including a shell.  This package can be very
useful for recovering from certain types of system failures,
particularly those involving broken shared libraries.

%description petitboot
Busybox is a single binary which includes versions of a large number
of system commands, including a shell.  The version contained in this
package is a minimal configuration intended for use with the Petitboot
bootloader used on PlayStation 3. The busybox package provides a binary
better suited to normal use.

%description static
Busybox is a single binary which includes versions of a large number
of system commands, including a shell.  The version contained in this
package is a static compilation of the busybox executable, and therefore 
requires no libraries during execution.

%package links
Summary:      Make busybox symlinks
Group:        System/Base
Requires:     %{name}

%description links
Make busybox symlinks

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

#post links
#. /usr/bin/busybox.mklinks /


%prep
%setup -q -n %{name}-%{version} -a 999
%patch16 -b .ia64 -p1
%patch329561 -p1
%patch32956 -p1
%patch74876 -p1
%patch84937 -p1

#Skiboot patches
%if "%{?dist}" == ".skiboot1_0"
%patch99578 -p1
%endif

#IOMC patches
%if "%{?dist}" == ".iomc_harrier"
%patch79503 -p1
%endif

%build
%define CONFIG %( (test -e %{_sourcedir}/busybox-config%{?dist} && echo %{_sourcedir}/busybox-config%{?dist} ) || echo %{SOURCE1} )
%define PETITBOOTCONFIG %( (test -e %{_sourcedir}/busybox-petitboot.config%{?dist} && echo %{_sourcedir}/busybox-petitboot.config%{?dist} ) || echo %{SOURCE2} )
%define STATICCONFIG %( (test -e %{_sourcedir}/busybox-static.config%{?dist} && echo %{_sourcedir}/busybox-static.config%{?dist} ) || echo %{SOURCE4} )

# LTCBZ 71549: Need -mminimal-toc on ppc64 arches
%ifarch ppc64 ppca2
export RPM_OPT_FLAGS+=" -mminimal-toc"
%endif

cp %{CONFIG} .config
# set all new options to defaults
yes "" | make oldconfig
cat .config && \
make V=1 CC="%__cc $RPM_OPT_FLAGS";
make V=1 CC="%__cc $RPM_OPT_FLAGS" busybox.links
cp busybox_unstripped busybox.base
cp docs/busybox.1 docs/busybox.base.1
cp busybox.links base-busybox.links

# create busybox optimized for petitboot
make clean
# copy new configuration file
cp %{PETITBOOTCONFIG} .config
# set all new options to defaults
yes "" | make oldconfig
make V=1 CC="%__cc $RPM_OPT_FLAGS"
cp busybox_unstripped busybox.petitboot
cp docs/busybox.1 docs/busybox.petitboot.1

# build busybox.static
make clean
cp %{STATICCONFIG} .config
yes "" | make oldconfig
make V=1 CC="%__cc $RPM_OPT_FLAGS"
cp busybox_unstripped busybox.static

pushd fivextra
make CC=%{__cc} all
popd

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/share/%{name}
install -m 755 %{SOURCE7} $RPM_BUILD_ROOT/usr/bin/busybox.mklinks
install -m 755 busybox.base $RPM_BUILD_ROOT/sbin/busybox
install -m 755 busybox.petitboot $RPM_BUILD_ROOT/sbin/busybox.petitboot
install -m 755 busybox.static $RPM_BUILD_ROOT/sbin/busybox.static
install base-busybox.links $RPM_BUILD_ROOT/usr/share/busybox/busybox.links
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man1
install -m 644 docs/busybox.base.1 $RPM_BUILD_ROOT/%{_mandir}/man1/busybox.1
install -m 644 docs/busybox.petitboot.1 $RPM_BUILD_ROOT/%{_mandir}/man1/busybox.petitboot.1

# Steps to package the busybox tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
-name '*.c' | xargs rm -rf

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc LICENSE README
/sbin/busybox
%{_mandir}/man1/busybox.1.gz

%files petitboot
%defattr(-,root,root,-)
%doc LICENSE README
/sbin/busybox.petitboot
%{_mandir}/man1/busybox.petitboot.1.gz

%files static
%defattr(-,root,root,-)
%doc LICENSE README
/sbin/busybox.static

%files links
%defattr(-,root,root,-)
%config /usr/share/busybox/busybox.links
/usr/bin/busybox.mklinks

%files fivextra
%{prefix}

%changelog
* Fri Jun 28 2013 baseuser@ibm.com
- Initial base-8 spec file
