%global multilib_arches %{ix86} ppc %{power64} s390 s390x x86_64

Name:		libffi
Version:	3.0.13
%define base_release .4
Release:	4%{?dist}%{?base_release}
Summary:	A portable foreign function interface library

Group:		System Environment/Libraries
License:	BSD
URL:		http://sourceware.org/libffi
Source0:	ftp://sourceware.org/pub/libffi/libffi-%{version}.tar.gz
Source999:	fivextra.tar.bz2
# part of upstream commit 5feacad4
Source1:	ffi-multilib.h
Source2:	ffitarget-multilib.h
Patch0:		libffi-3.0.13-fix-include-path.patch
# part of upstream commit 5feacad4
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

# LTC: temp workaround till we rebuild deps against libffi.so.6
%ifarch x86_64 ppc64 s390x
Provides:   libffi.so.5()(64bit)
%else
Provides:   libffi.so.5
%endif

%description
Compilers for high level languages generate code that follow certain
conventions.  These conventions are necessary, in part, for separate
compilation to work.  One such convention is the "calling convention".
The calling convention is a set of assumptions made by the compiler
about where function arguments will be found on entry to a function.  A
calling convention also specifies where the return value for a function
is found.  

Some programs may not know at the time of compilation what arguments
are to be passed to a function.  For instance, an interpreter may be
told at run-time about the number and types of arguments used to call a
given function.  `Libffi' can be used in such programs to provide a
bridge from the interpreter program to compiled code.

The `libffi' library provides a portable, high level programming
interface to various calling conventions.  This allows a programmer to
call any function specified by a call interface description at run time.

FFI stands for Foreign Function Interface.  A foreign function
interface is the popular name for the interface that allows code
written in one language to call code written in another language.  The
`libffi' library really only provides the lowest, machine dependent
layer of a fully featured foreign function interface.  A layer must
exist above `libffi' that handles type conversions for values passed
between the two languages.  


%package	devel
Summary:	Development files for %{name}
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:       pkgconfig
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

%description	devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package fivextra
Summary: Testsuite for Foreign Function Interface Library
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: dejagnu
AutoProv: no

%description fivextra
The testsuite allows testing of FFI (Foreign Function Interface)
Library.

%prep
%setup -q -a 999
%patch0 -p1 -b .fixpath


%build
%configure --disable-static
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

# Determine generic arch target name for multilib wrapper
basearch=%{_arch}
%ifarch %{ix86}
basearch=i386
%endif

%ifarch %{multilib_arches}
# Do header file switcheroo to avoid file conflicts on systems where you
# can have both a 32- and 64-bit version of the library, and they each need
# their own correct-but-different versions of the headers to be usable.
for i in ffi ffitarget; do
  mv $RPM_BUILD_ROOT%{_includedir}/$i.h $RPM_BUILD_ROOT%{_includedir}/$i-${basearch}.h
done
install -m644 %{SOURCE1} $RPM_BUILD_ROOT%{_includedir}/ffi.h
install -m644 %{SOURCE2} $RPM_BUILD_ROOT%{_includedir}/ffitarget.h
%else
# source hack
touch %{SOURCE1} %{SOURCE2}
%endif

# LTC: temp workaround till we rebuild deps against libffi.so.6
pushd $RPM_BUILD_ROOT%{_libdir}
ln -s libffi.so.6.0* libffi.so.5
popd

# Steps to package the libffi tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find testsuite src include -type d)
do
  install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

# testsuite needs .libs amd fficonfig.h
pwd
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/.libs
#install -m 755 .libs/libffi.so $RPM_BUILD_ROOT/%{fivdir}/%{name}/.libs/
#install ./fficonfig.h $RPM_BUILD_ROOT/%{fivdir}/%{name}/include/

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
  -name '*.o' -o -name '*.in' -o -name 'Makefile*' -o -name '*.lo' | xargs rm -rf
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/src -name '*.c' -o -name '.d*' \
  -o -name '.libs' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT


%post -p /sbin/ldconfig

%post devel
/sbin/install-info --info-dir=%{_infodir} %{_infodir}/libffi.info.gz

%preun devel
if [ $1 = 0 ] ;then
  /sbin/install-info --delete --info-dir=%{_infodir} %{_infodir}/libffi.info.gz
fi

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%doc LICENSE README
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root,-)
%{_libdir}/pkgconfig/*.pc
%{_includedir}/ffi*.h
%{_libdir}/*.so
%{_mandir}/man3/*.gz
%{_infodir}/libffi.info.gz

%files fivextra
%{prefix}

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
