Name:           libldm
Version:        0.2.3
%define base_release .2
Release:        1%{?dist}%{?base_release}%{?extra_release}
Summary:        A tool to manage Windows dynamic disks
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}

License:        LGPLv3+ and GPLv3+
URL:            https://github.com/mdbooth/libldm 
Source0:        %{url}/downloads/%{name}-%{version}.tar.gz
Patch0:         cast_be64toh.patch
Patch1:		remove_g_type_init.patch

BuildRequires:  glib2-devel >= 2.26.0
BuildRequires:  json-glib-devel >= 0.14.0
BuildRequires:  device-mapper-devel >= 1.0
BuildRequires:  zlib-devel libuuid-devel readline-devel gtk-doc


%description
libldm is a library for managing Microsoft Windows dynamic disks, which use
Microsoft's LDM metadata. It can inspect them, and also create and remove
device-mapper block devices which can be mounted. It includes ldmtool, which
exposes this functionality as a command-line tool.

libldm is released under LGPLv3+. ldmtool is released under GPLv3+.


%package        devel
Summary:        Development files for %{name}
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q
%patch0 -p1
%patch1 -p0

%build
%configure --disable-static --enable-gtk-doc
make %{?_smp_mflags}


%install
%make_install
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%doc COPYING.lgpl COPYING.gpl
%{_libdir}/*.so.*
%{_bindir}/ldmtool
%{_mandir}/man1/ldmtool.1.gz


%files devel
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/ldm-1.0.pc
%{_datadir}/gtk-doc


%changelog
* Tue Aug 13 2013 baseuser@ibm.com
- Base-8.x spec file
