Summary:	C library for parsing command line parameters
Name:		popt
Version:	1.13
%define base_release .2
Release:	14%{?dist}%{?base_release}
License:	MIT
Group:		System Environment/Libraries
URL:		http://www.rpm5.org/
Source:		http://www.rpm5.org/files/%{name}/%{name}-%{version}.tar.gz
Source999:       fivextra.tar.bz2
Patch1:		popt-1.13-popt_fprintf.patch
Patch2:		popt-1.13-alias-equal-arg.patch
Patch3:		popt-1.13-execfail.patch
Patch1001:     bug66459-fiv-changes-popt.diff
BuildRequires:	gettext
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Popt is a C library for parsing command line parameters. Popt was
heavily influenced by the getopt() and getopt_long() functions, but
it improves on them by allowing more powerful argument expansion.
Popt can parse arbitrary argv[] style arrays and automatically set
variables based on command line arguments. Popt allows command line
arguments to be aliased via configuration files and includes utility
functions for parsing arbitrary strings into argv[] arrays using
shell-like rules.

%package devel
Summary:	Development files for the popt library
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description devel
The popt-devel package includes header files and libraries necessary
for developing programs which use the popt C library. It contains the
API documentation of the popt library, too.

%package static
Summary:	Static library for parsing command line parameters
Group:		Development/Libraries
Requires:	%{name}-devel = %{version}-%{release}

%description static
The popt-static package includes static libraries of the popt library.
Install it if you need to link statically with libpopt.

%package fivextra
Summary: Tests for FIV
Group: fivextra
Prefix: /opt/fiv/ltp
#Requires: %{name} >= %{version}-%{release}

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch1 -p1 -b .popt_fprintf
%patch2 -p1 -b .alias-equal-arg
%patch3 -p1 -b .execfail
%patch1001 -p1

%build
%configure --libdir=/%{_lib}
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# Move libpopt.{so,a} to %{_libdir}
rm -f $RPM_BUILD_ROOT/%{_lib}/libpopt.{la,so}
pushd $RPM_BUILD_ROOT/%{_lib}
mkdir -p $RPM_BUILD_ROOT%{_libdir}
ln -sf ../../%{_lib}/$(ls libpopt.so.?.?.?) $RPM_BUILD_ROOT%{_libdir}/libpopt.so
popd
mv -f $RPM_BUILD_ROOT/%{_lib}/libpopt.a $RPM_BUILD_ROOT%{_libdir}/libpopt.a

# Multiple popt configurations are possible
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/popt.d

# FIV Changes
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp testit.sh $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp .libs/test* $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp -a test3-data $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp test-poptrc $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp test*.c $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/

# Steps to package the popt tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
  -name '*.c' | xargs rm -rf

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%check
#make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-,root,root)
%doc CHANGES COPYING
%{_sysconfdir}/popt.d
/%{_lib}/libpopt.so.*

%files devel
%defattr(-,root,root)
%doc README
%{_libdir}/libpopt.so
%{_includedir}/popt.h
%{_mandir}/man3/popt.3*

%files static
%defattr(-,root,root)
%{_libdir}/libpopt.a

%files fivextra
%defattr(-,root,root)
%{prefix}

%changelog
* Mon May 20 2013 baseuser@ibm.com
- Base-8.x spec file
