# we don't have python3
# if 0%{?fedora} > 12
# global with_python3 1
# else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
# endif

%if 0%{?rhel} == 5
%global with_python26 1
%endif

%if 0%{?with_python26}
%global __python26 %{_bindir}/python2.6
%global py26dir %{_builddir}/python26-%{name}-%{version}-%{release}
%{!?python26_sitelib: %global python26_sitelib %(%{__python26} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
# Update rpm byte compilation script so that we get the modules compiled by the
# correct inerpreter
%global __os_install_post %__multiple_python_os_install_post
%endif


%global upstream_name Pygments

Name:           python-pygments
Version:        1.4
%define base_release .3
Release:        8%{?dist}%{?base_release}
Summary:        Syntax highlighting engine written in Python

Group:          Development/Libraries
License:        BSD
URL:            http://pygments.org/
Source0:        http://pypi.python.org/packages/source/P/%{upstream_name}/%{upstream_name}-%{version}.tar.gz

Source100:      bug109636-remove-test.mod
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python2-devel >= 2.4, python-setuptools, python-nose
BuildRequires:  fakeroot-tools
%if 0%{?with_python3}
BuildRequires:  python3-devel, python3-setuptools
%if 0%{?fedora} >= 15
BuildRequires: python3-nose
%endif
%endif # if with_python3
Requires:       python-setuptools, python-imaging
%if 0%{?with_python26}
BuildRequires:  python26-devel, python26-distribute
%endif


%description
Pygments is a generic syntax highlighter for general use in all kinds
of software such as forum systems, wikis or other applications that
need to prettify source code. Highlights are:

  * a wide range of common languages and markup formats is supported
  * special attention is paid to details that increase highlighting
    quality
  * support for new languages and formats are added easily; most
    languages use a simple regex-based lexing mechanism
  * a number of output formats is available, among them HTML, RTF,
    LaTeX and ANSI sequences
  * it is usable as a command-line tool and as a library
  * ... and it highlights even Brainf*ck!

%if 0%{?with_python3}
%package -n python3-pygments
Summary:        Syntax highlighting engine written in Python 3
Group:          Development/Libraries
Requires:       python3-setuptools

%description -n python3-pygments
Pygments is a generic syntax highlighter for general use in all kinds
of software such as forum systems, wikis or other applications that
need to prettify source code. Highlights are:

  * a wide range of common languages and markup formats is supported
  * special attention is paid to details that increase highlighting
    quality
  * support for new languages and formats are added easily; most
    languages use a simple regex-based lexing mechanism
  * a number of output formats is available, among them HTML, RTF,
    LaTeX and ANSI sequences
  * it is usable as a command-line tool and as a library
  * ... and it highlights even Brainf*ck!
%endif # if with_python3

%if 0%{?with_python26}
%package -n python26-pygments
Summary:        A syntax highlighting engine written in Python 2.6
Group:          Development/Libraries
Requires:       python26-distribute
Requires:       python26-imaging
Requires:       python(abi) = 2.6

%description -n python26-pygments
Pygments is a generic syntax highlighter for general use in all kinds
of software such as forum systems, wikis or other applications that
need to prettify source code. Highlights are:
%endif #end of python2.6


%prep
%setup -q -n Pygments-%{version}

file_remover.sh %{SOURCE100}
%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif # with_python3

%if 0%{?with_python26}
rm -rf %{py26dir}
cp -a . %{py26dir}
find %{py26dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python26}|'
%endif # with_python26


%build
%{__python} setup.py build
%{__sed} -i 's/\r//' LICENSE

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

%if 0%{?with_python26}
pushd %{py26dir}
%{__python26} setup.py build
popd
%endif # with_python26


%install
rm -rf $RPM_BUILD_ROOT

# Run the Python 3 build first so that the Python 2 version of
# /usr/bin/pygmentize "wins":
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python3

# Run the Python 2.6 build first so that the Python 2 version of
# /usr/bin/pygmentize "wins":
%if 0%{?with_python26}
pushd %{py26dir}
%{__python26} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python26

%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT
pushd docs
install -d %{buildroot}%{_mandir}/man1
mv pygmentize.1 $RPM_BUILD_ROOT%{_mandir}/man1/pygmentize.1
mv build html
mv src reST
popd


%clean
rm -rf $RPM_BUILD_ROOT


%check
make test

%if 0%{?with_python26}
pushd %{py26dir}
# There's currently no python26-nose
#make test
popd
%endif # with_python26

# python3-nose is available from f15 on
%if 0%{?with_python3}
pushd %{py3dir}
%if 0%{?fedora} >= 15
make test
%endif
popd
%endif # with_python3


%files
%defattr(-,root,root,-)
%doc AUTHORS CHANGES docs/html docs/reST LICENSE TODO
# For noarch packages: sitelib
%{python_sitelib}/*
%{_bindir}/pygmentize
%lang(en) %{_mandir}/man1/pygmentize.1.gz

%if 0%{?with_python3}
%files -n python3-pygments
%defattr(-,root,root,-)
%doc AUTHORS CHANGES docs/html docs/reST LICENSE TODO
%{python3_sitelib}/*
%endif # with_python3

%if 0%{?with_python26}
%files -n python26-pygments
%defattr(-,root,root,-)
%doc AUTHORS CHANGES docs/ LICENSE TODO
%{python26_sitelib}/*
%endif # with_python26


%changelog
* Fri Aug 23 2013 baseuser@ibm.com
- Base-8.x spec file
