%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

# Keep this value in sync with the definition in openssl.spec.
%global multilib_arches %{ix86} ia64 ppc ppc64 s390 s390x x86_64 sparc sparcv9 sparc64

Summary: Support for using OpenSSL in python scripts
Name: m2crypto
Version: 0.21.1
%define base_release .4
Release: 11%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Source0: http://pypi.python.org/packages/source/M/M2Crypto/M2Crypto-%{version}.tar.gz
Source999: fivextra.tar.bz2
# https://bugzilla.osafoundation.org/show_bug.cgi?id=2341
Patch0: m2crypto-0.21.1-timeouts.patch
# This is only precautionary, it does fix anything - not sent upstream
Patch1: m2crypto-0.21.1-gcc_macros.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=12972
Patch2: m2crypto-0.20.2-fips.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=12973
Patch3: m2crypto-0.20.2-check.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13005
Patch4: m2crypto-0.21.1-memoryview.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13020
Patch5: m2crypto-0.21.1-smime-doc.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=12999
Patch6: m2crypto-0.21.1-AES_crypt.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13044
Patch7: m2crypto-0.21.1-IPv6.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13049
Patch8: m2crypto-0.21.1-https-proxy.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13066
Patch9: m2crypto-0.21.1-certs.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13072
Patch10: m2crypto-0.21.1-ssl23.patch
# https://bugzilla.osafoundation.org/show_bug.cgi?id=13103
Patch11: m2crypto-0.21.1-tests-no-export-ciphers.patch
License: MIT
Group: System Environment/Libraries
URL: http://wiki.osafoundation.org/bin/view/Projects/MeTooCrypto
BuildRequires: openssl, openssl-devel, python2-devel
BuildRequires: perl, pkgconfig, swig, which

%filter_provides_in %{python_sitearch}/M2Crypto/__m2crypto.so
%filter_setup

%description
This package allows you to call OpenSSL functions from python scripts.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n M2Crypto-%{version} -a 999
%patch0 -p1 -b .timeouts
%patch1 -p1 -b .gcc_macros
%patch2 -p1 -b .fips
%patch3 -p1 -b .check
%patch4 -p1 -b .memoryview
%patch5 -p0
%patch6 -p0 -b .AES_crypt
%patch7 -p1 -b .IPv6
%patch8 -p1 -b .https-proxy
%patch9 -p0 -b .certs
openssl x509 -in tests/x509.pem -out tests/x509.der -outform DER
%patch10 -p0 -b .ssl23
%patch11 -p1 -b .tests-no-export-ciphers

# Red Hat opensslconf.h #includes an architecture-specific file, but SWIG
# doesn't follow the #include.

# Determine which arch opensslconf.h is going to try to #include.
basearch=%{_arch}
%ifarch %{ix86}
basearch=i386
%endif
%ifarch sparcv9
basearch=sparc
%endif
%ifarch %{multilib_arches}
for i in SWIG/_ec.i SWIG/_evp.i; do
	sed -i -e "s/opensslconf/opensslconf-${basearch}/" "$i"
done
%endif

gcc -E -dM - < /dev/null | grep -v __STDC__ \
	| sed 's/^\(#define \([^ ]*\) .*\)$/#undef \2\n\1/' > SWIG/gcc_macros.h

%build
CFLAGS="$RPM_OPT_FLAGS" ; export CFLAGS
if pkg-config openssl ; then
	CFLAGS="$CFLAGS `pkg-config --cflags openssl`" ; export CFLAGS
	LDFLAGS="$LDFLAGS`pkg-config --libs-only-L openssl`" ; export LDFLAGS
fi

# -cpperraswarn is necessary for including opensslconf-${basearch} directly
SWIG_FEATURES=-cpperraswarn %{__python} setup.py build

%install
CFLAGS="$RPM_OPT_FLAGS" ; export CFLAGS
if pkg-config openssl ; then
	CFLAGS="$CFLAGS `pkg-config --cflags openssl`" ; export CFLAGS
	LDFLAGS="$LDFLAGS`pkg-config --libs-only-L openssl`" ; export LDFLAGS
fi

%{__python} setup.py install --root=$RPM_BUILD_ROOT

for i in medusa medusa054; do
	sed -i -e '1s,#! /usr/local/bin/python,#! %{__python},' \
		demo/$i/http_server.py
done

# Windows-only
rm demo/Zope/starts.bat
# Fix up documentation permissions
find demo tests -type f -perm -111 -print0 | xargs -0 chmod a-x

grep -rl '/usr/bin/env python' demo tests \
	| xargs sed -i "s,/usr/bin/env python,%{__python},"

rm -f tests/*.{pem,py}.* # Patch backup files

# Steps to package the m2crypto tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find tests -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%doc CHANGES LICENCE README demo tests
%{python_sitearch}/M2Crypto
%{python_sitearch}/M2Crypto-*.egg-info

%files fivextra
%{prefix}

%changelog
* Wed Sep 18 2013 baseuser@ibm.com
- Base-8.x spec file
